<?php

/**
 * @file
 *
 */

function incubator_tours_help() {
  global $user;
  if ($user->data['hide_incubator_tours']) {
    drupal_set_message(t('You have disabled automated tours for your account! You must first enable them !here.', array('!here' => l('here', 'user/' . $user->uid . '/edit'))), 'warning');
  }
  $tours = incubator_tours_get_tours('*');
  $output = array();
  // Add elements to page bottom
  $output['_incubator_tours_joyride'] = array(
    '#prefix' => '<div class="incubator-tours-joyride">',
    '#suffix' => '</div>',
  );
  foreach ($tours as $name => $tour) {
    if (isset($tour['help section'])) {
      $section = $tour['help section'];
      $output[$section]['#theme'] = 'item_list';
      $output[$section]['#items'][] = l($tour['label'], '', array(
        'attributes' => array(
          'class' => array(
            'incubator-tours-start-link'
          ),
          'data-id' => $tour['id'],
        ),
      ));
      if (!empty($tour['help section'])) {
        $output[$section]['#prefix'] = '<h3>' . $section . '</h3>';
      }
      $output['_incubator_tours_joyride'][$name] = array(
        '#theme' => 'item_list',
        '#items' => $tour['tips'],
        '#attributes' => array(
          'id' => $tour['id'],
        ),
      );
    }
  }
  ksort($output);
  
  return $output;
}
