<?php

/**
 * @file
 *
 */

function _incubator_events_get_bahaicalendar($year) {
  
  // Initialize arrays
  $bahaical = array();
  $years = _incubator_events_bahaicalendar_years();
  
  // For years before 2015, the dates are standard
  if ($year < 2015) {
    $bahaical = _incubator_events_bahaicalendar_table('pre-2015');
  }
  // For other years not in the table, the dates are not figured
  elseif (!in_array($year, array_keys($years))) {
    return FALSE;
  }
  // Get dates for years in the table
  else {
    $bahaical = _incubator_events_bahaicalendar_table($years[$year]['type']);
    $bahaical['holyday']{$years[$year]['birthdays'][0]} = t('Birth of the Báb');
    $bahaical['holyday']{$years[$year]['birthdays'][1]} = t("Birth of Bahá'u'lláh");
  }
  
  // Add Ayyám-i-Há day for Feb. 29 if needed
  if (date('L', mktime(0, 0, 0, 1, 1, $year))) {
    $bahaical['ayyamiha']['02-29'] = t('Ayyám-i-Há');
  }
  
  return $bahaical;
  
}

function _incubator_events_bahaicalendar_years() {
  return array(
    '2015' => array('type' => 'bb', 'birthdays' => array('11-13', '11-14')),
    '2016' => array('type' => 'ba', 'birthdays' => array('11-01', '11-02')),
    '2017' => array('type' => 'aa', 'birthdays' => array('10-21', '10-22')),
    '2018' => array('type' => 'ab', 'birthdays' => array('11-09', '11-10')),
    '2019' => array('type' => 'bb', 'birthdays' => array('10-29', '10-30')),
    '2020' => array('type' => 'ba', 'birthdays' => array('10-18', '10-19')),
    '2021' => array('type' => 'aa', 'birthdays' => array('11-06', '11-07')),
    '2022' => array('type' => 'ab', 'birthdays' => array('10-26', '10-27')),
    '2023' => array('type' => 'bb', 'birthdays' => array('10-16', '10-17')),
    '2024' => array('type' => 'ba', 'birthdays' => array('11-02', '11-03')),
    '2025' => array('type' => 'aa', 'birthdays' => array('10-22', '10-23')),
    '2026' => array('type' => 'ab', 'birthdays' => array('11-10', '11-11')),
    '2027' => array('type' => 'bb', 'birthdays' => array('10-30', '10-31')),
    '2028' => array('type' => 'ba', 'birthdays' => array('10-19', '10-20')),
    '2029' => array('type' => 'aa', 'birthdays' => array('11-07', '11-08')),
    '2030' => array('type' => 'aa', 'birthdays' => array('10-28', '10-29')),
    '2031' => array('type' => 'ab', 'birthdays' => array('10-17', '10-18')),
    '2032' => array('type' => 'ba', 'birthdays' => array('11-04', '11-05')),
    '2033' => array('type' => 'aa', 'birthdays' => array('10-24', '10-25')),
    '2034' => array('type' => 'aa', 'birthdays' => array('11-12', '11-13')),
    '2035' => array('type' => 'ab', 'birthdays' => array('11-01', '11-02')),
    '2036' => array('type' => 'ba', 'birthdays' => array('10-20', '10-21')),
    '2037' => array('type' => 'aa', 'birthdays' => array('11-08', '11-09')),
    '2038' => array('type' => 'aa', 'birthdays' => array('10-29', '10-30')),
    '2039' => array('type' => 'ab', 'birthdays' => array('10-19', '10-20')),
    '2040' => array('type' => 'ba', 'birthdays' => array('11-06', '11-07')),
    '2041' => array('type' => 'aa', 'birthdays' => array('10-26', '10-27')),
    '2042' => array('type' => 'aa', 'birthdays' => array('10-15', '10-16')),
    '2043' => array('type' => 'ab', 'birthdays' => array('11-03', '11-04')),
    '2044' => array('type' => 'ba', 'birthdays' => array('10-22', '10-23')),
    '2045' => array('type' => 'aa', 'birthdays' => array('11-10', '11-11')),
    '2046' => array('type' => 'aa', 'birthdays' => array('10-30', '10-31')),
    '2047' => array('type' => 'ab', 'birthdays' => array('10-20', '10-21')),
    '2048' => array('type' => 'ba', 'birthdays' => array('11-07', '11-08')),
    '2049' => array('type' => 'aa', 'birthdays' => array('10-28', '10-29')),
    '2050' => array('type' => 'aa', 'birthdays' => array('10-17', '10-18')),
    '2051' => array('type' => 'ab', 'birthdays' => array('11-05', '11-06')),
    '2052' => array('type' => 'ba', 'birthdays' => array('10-24', '10-25')),
    '2053' => array('type' => 'aa', 'birthdays' => array('11-11', '11-12')),
    '2054' => array('type' => 'aa', 'birthdays' => array('11-01', '11-02')),
    '2055' => array('type' => 'ab', 'birthdays' => array('10-21', '10-22')),
    '2056' => array('type' => 'ba', 'birthdays' => array('11-08', '11-09')),
    '2057' => array('type' => 'aa', 'birthdays' => array('10-29', '10-30')),
    '2058' => array('type' => 'aa', 'birthdays' => array('10-18', '10-19')),
    '2059' => array('type' => 'aa', 'birthdays' => array('11-06', '11-07')),
    '2060' => array('type' => 'aa', 'birthdays' => array('10-25', '10-26')),
    '2061' => array('type' => 'aa', 'birthdays' => array('10-14', '10-15')),
    '2062' => array('type' => 'aa', 'birthdays' => array('11-02', '11-03')),
    '2063' => array('type' => 'aa', 'birthdays' => array('10-23', '10-24')),
    '2064' => array('type' => 'aa', 'birthdays' => array('11-10', '11-11')),
  );
}

function _incubator_events_bahaicalendar_table($year_type) {
  $bahaical['pre-2015'] = array(
    'holyday' => array(
      '03-21' => t("Naw-Rúz (New Year)"), // non-breaking space in New Year
      '04-21' => t("First Day of Riḍván"),
      '04-29' => t("Ninth Day of Riḍván"),
      '05-02' => t("Twelfth Day of Riḍván"),
      '05-23' => t("Declaration of The Báb"),
      '05-29' => t("Ascension of Bahá'u'lláh"),
      '07-09' => t("Martyrdom of The Báb"),
      '10-20' => t("Birth of The Báb"),
      '11-12' => t("Birth of Bahá'u'lláh"),
    ),
    'workingholyday' => array(
      '04-22' => t('Riḍván Festival'),
      '04-23' => t('Riḍván Festival'),
      '04-24' => t('Riḍván Festival'),
      '04-25' => t('Riḍván Festival'),
      '04-26' => t('Riḍván Festival'),
      '04-27' => t('Riḍván Festival'),
      '04-28' => t('Riḍván Festival'),
      '04-30' => t('Riḍván Festival'),
      '05-01' => t('Riḍván Festival'),
      '11-26' => t("Day of the Covenant"),
      '11-28' => t("Ascension of 'Abdu'l‑Bahá"), // non-breaking hyphen
    ),
    'feast' => array(
      '03-21' => t("Bahá (Splendor)"),
      '04-09' => t("Jalál (Glory)"),
      '04-28' => t("Jamál (Beauty)"),
      '05-17' => t("‘Aẓamat (Grandeur)"),
      '06-05' => t("Núr (Light)"),
      '06-24' => t("Raḥmat (Mercy)"),
      '07-13' => t("Kalimát (Words)"),
      '08-01' => t("Kamál (Perfection)"),
      '08-20' => t("Asmá’ (Names)"),
      '09-08' => t("‘Izzát (Might)"),
      '09-27' => t("Mashíyyat (Will)"),
      '10-16' => t("‘Ilm (Knowledge)"),
      '11-04' => t("Qudrat (Power)"),
      '11-23' => t("Qawl (Speech)"),
      '12-12' => t("Masá'il (Questions)"),
      '12-31' => t("Sharaf (Honor)"),
      '01-19' => t("Sulṭán (Sovereignty)"),
      '02-07' => t("Mulk (Dominion)"),
      '03-02' => t("‘Alá’ (Loftiness)"),
    ),
    'ayyamiha' => array(
      '02-26' => t('Ayyám-i-Há'),
      '02-27' => t('Ayyám-i-Há'),
      '02-28' => t('Ayyám-i-Há'),
      '03-01' => t('Ayyám-i-Há'),
    ),
  );
  $bahaical['bb'] = array(
    'holyday' => array(
      '03-21' => t("Naw-Rúz (New Year)"), // non-breaking space in New Year
      '04-21' => t("First Day of Riḍván"),
      '04-29' => t("Ninth Day of Riḍván"),
      '05-02' => t("Twelfth Day of Riḍván"),
      '05-24' => t("Declaration of The Báb"),
      '05-29' => t("Ascension of Bahá'u'lláh"),
      '07-10' => t("Martyrdom of The Báb"),
    ),
    'workingholyday' => array(
      '04-22' => t('Riḍván Festival'),
      '04-23' => t('Riḍván Festival'),
      '04-24' => t('Riḍván Festival'),
      '04-25' => t('Riḍván Festival'),
      '04-26' => t('Riḍván Festival'),
      '04-27' => t('Riḍván Festival'),
      '04-28' => t('Riḍván Festival'),
      '04-30' => t('Riḍván Festival'),
      '05-01' => t('Riḍván Festival'),
      '11-26' => t("Day of the Covenant"),
      '11-28' => t("Ascension of 'Abdu'l‑Bahá"), // non-breaking hyphen
    ),
    'feast' => array(
      '03-21' => t("Bahá (Splendor)"),
      '04-09' => t("Jalál (Glory)"),
      '04-28' => t("Jamál (Beauty)"),
      '05-17' => t("‘Aẓamat (Grandeur)"),
      '06-05' => t("Núr (Light)"),
      '06-24' => t("Raḥmat (Mercy)"),
      '07-13' => t("Kalimát (Words)"),
      '08-01' => t("Kamál (Perfection)"),
      '08-20' => t("Asmá’ (Names)"),
      '09-08' => t("‘Izzát (Might)"),
      '09-27' => t("Mashíyyat (Will)"),
      '10-16' => t("‘Ilm (Knowledge)"),
      '11-04' => t("Qudrat (Power)"),
      '11-23' => t("Qawl (Speech)"),
      '12-12' => t("Masá'il (Questions)"),
      '12-31' => t("Sharaf (Honor)"),
      '01-19' => t("Sulṭán (Sovereignty)"),
      '02-07' => t("Mulk (Dominion)"),
      '03-02' => t("‘Alá’ (Loftiness)"),
    ),
    'ayyamiha' => array(
      '02-26' => t('Ayyám-i-Há'),
      '02-27' => t('Ayyám-i-Há'),
      '02-28' => t('Ayyám-i-Há'),
      '03-01' => t('Ayyám-i-Há'),
    ),
  );
  $bahaical['ab'] = array(
    'holyday' => array(
      '03-21' => t("Naw-Rúz (New Year)"), // non-breaking space in New Year
      '04-21' => t("First Day of Riḍván"),
      '04-29' => t("Ninth Day of Riḍván"),
      '05-02' => t("Twelfth Day of Riḍván"),
      '05-24' => t("Declaration of The Báb"),
      '05-29' => t("Ascension of Bahá'u'lláh"),
      '07-10' => t("Martyrdom of The Báb"),
    ),
    'workingholyday' => array(
      '04-22' => t('Riḍván Festival'),
      '04-23' => t('Riḍván Festival'),
      '04-24' => t('Riḍván Festival'),
      '04-25' => t('Riḍván Festival'),
      '04-26' => t('Riḍván Festival'),
      '04-27' => t('Riḍván Festival'),
      '04-28' => t('Riḍván Festival'),
      '04-30' => t('Riḍván Festival'),
      '05-01' => t('Riḍván Festival'),
      '11-26' => t("Day of the Covenant"),
      '11-28' => t("Ascension of 'Abdu'l‑Bahá"), // non-breaking hyphen
    ),
    'feast' => array(
      '03-21' => t("Bahá (Splendor)"),
      '04-09' => t("Jalál (Glory)"),
      '04-28' => t("Jamál (Beauty)"),
      '05-17' => t("‘Aẓamat (Grandeur)"),
      '06-05' => t("Núr (Light)"),
      '06-24' => t("Raḥmat (Mercy)"),
      '07-13' => t("Kalimát (Words)"),
      '08-01' => t("Kamál (Perfection)"),
      '08-20' => t("Asmá’ (Names)"),
      '09-08' => t("‘Izzát (Might)"),
      '09-27' => t("Mashíyyat (Will)"),
      '10-16' => t("‘Ilm (Knowledge)"),
      '11-04' => t("Qudrat (Power)"),
      '11-23' => t("Qawl (Speech)"),
      '12-12' => t("Masá'il (Questions)"),
      '12-31' => t("Sharaf (Honor)"),
      '01-18' => t("Sulṭán (Sovereignty)"),
      '02-06' => t("Mulk (Dominion)"),
      '03-02' => t("‘Alá’ (Loftiness)"),
    ),
    'ayyamiha' => array(
      '02-25' => t('Ayyám-i-Há'),
      '02-26' => t('Ayyám-i-Há'),
      '02-27' => t('Ayyám-i-Há'),
      '02-28' => t('Ayyám-i-Há'),
      '03-01' => t('Ayyám-i-Há'),
    ),
  );
  $bahaical['ba'] = array(
    'holyday' => array(
      '03-20' => t("Naw-Rúz (New Year)"), // non-breaking space in New Year
      '04-20' => t("First Day of Riḍván"),
      '04-28' => t("Ninth Day of Riḍván"),
      '05-01' => t("Twelfth Day of Riḍván"),
      '05-23' => t("Declaration of The Báb"),
      '05-28' => t("Ascension of Bahá'u'lláh"),
      '07-09' => t("Martyrdom of The Báb"),
    ),
    'workingholyday' => array(
      '04-21' => t('Riḍván Festival'),
      '04-22' => t('Riḍván Festival'),
      '04-23' => t('Riḍván Festival'),
      '04-24' => t('Riḍván Festival'),
      '04-25' => t('Riḍván Festival'),
      '04-26' => t('Riḍván Festival'),
      '04-27' => t('Riḍván Festival'),
      '04-29' => t('Riḍván Festival'),
      '04-30' => t('Riḍván Festival'),
      '11-25' => t("Day of the Covenant"),
      '11-27' => t("Ascension of 'Abdu'l‑Bahá"), // non-breaking hyphen
    ),
    'feast' => array(
      '03-20' => t("Bahá (Splendor)"),
      '04-08' => t("Jalál (Glory)"),
      '04-27' => t("Jamál (Beauty)"),
      '05-16' => t("‘Aẓamat (Grandeur)"),
      '06-04' => t("Núr (Light)"),
      '06-23' => t("Raḥmat (Mercy)"),
      '07-12' => t("Kalimát (Words)"),
      '07-31' => t("Kamál (Perfection)"),
      '08-19' => t("Asmá’ (Names)"),
      '09-07' => t("‘Izzát (Might)"),
      '09-26' => t("Mashíyyat (Will)"),
      '10-15' => t("‘Ilm (Knowledge)"),
      '11-03' => t("Qudrat (Power)"),
      '11-22' => t("Qawl (Speech)"),
      '12-11' => t("Masá'il (Questions)"),
      '12-30' => t("Sharaf (Honor)"),
      '01-19' => t("Sulṭán (Sovereignty)"),
      '02-07' => t("Mulk (Dominion)"),
      '03-01' => t("‘Alá’ (Loftiness)"),
    ),
    'ayyamiha' => array(
      '02-26' => t('Ayyám-i-Há'),
      '02-27' => t('Ayyám-i-Há'),
      '02-28' => t('Ayyám-i-Há'),
    ),
  );
  $bahaical['aa'] = array(
    'holyday' => array(
      '03-20' => t("Naw-Rúz (New Year)"), // non-breaking space in New Year
      '04-20' => t("First Day of Riḍván"),
      '04-28' => t("Ninth Day of Riḍván"),
      '05-01' => t("Twelfth Day of Riḍván"),
      '05-23' => t("Declaration of The Báb"),
      '05-28' => t("Ascension of Bahá'u'lláh"),
      '07-09' => t("Martyrdom of The Báb"),
    ),
    'workingholyday' => array(
      '04-21' => t('Riḍván Festival'),
      '04-22' => t('Riḍván Festival'),
      '04-23' => t('Riḍván Festival'),
      '04-24' => t('Riḍván Festival'),
      '04-25' => t('Riḍván Festival'),
      '04-26' => t('Riḍván Festival'),
      '04-27' => t('Riḍván Festival'),
      '04-29' => t('Riḍván Festival'),
      '04-30' => t('Riḍván Festival'),
      '11-25' => t("Day of the Covenant"),
      '11-27' => t("Ascension of 'Abdu'l‑Bahá"), // non-breaking hyphen
    ),
    'feast' => array(
      '03-20' => t("Bahá (Splendor)"),
      '04-08' => t("Jalál (Glory)"),
      '04-27' => t("Jamál (Beauty)"),
      '05-16' => t("‘Aẓamat (Grandeur)"),
      '06-04' => t("Núr (Light)"),
      '06-23' => t("Raḥmat (Mercy)"),
      '07-12' => t("Kalimát (Words)"),
      '07-31' => t("Kamál (Perfection)"),
      '08-19' => t("Asmá’ (Names)"),
      '09-07' => t("‘Izzát (Might)"),
      '09-26' => t("Mashíyyat (Will)"),
      '10-15' => t("‘Ilm (Knowledge)"),
      '11-03' => t("Qudrat (Power)"),
      '11-22' => t("Qawl (Speech)"),
      '12-11' => t("Masá'il (Questions)"),
      '12-30' => t("Sharaf (Honor)"),
      '01-18' => t("Sulṭán (Sovereignty)"),
      '02-06' => t("Mulk (Dominion)"),
      '03-01' => t("‘Alá’ (Loftiness)"),
    ),
    'ayyamiha' => array(
      '02-25' => t('Ayyám-i-Há'),
      '02-26' => t('Ayyám-i-Há'),
      '02-27' => t('Ayyám-i-Há'),
      '02-28' => t('Ayyám-i-Há'),
    ),
  );
  return $bahaical[$year_type];
}
