<?php

/**
 * @file
 *
 */

function markerly_settings() {
  $settings = variable_get('markerly_settings', _markerly_defaults());

  // COLOR CHOOSER FORM
  if (module_exists('color')) {
    $theme = variable_get('theme_default', 'bartik');
    $palette = color_get_palette($theme);
    $colors = array_unique(array_values($palette));
    foreach ($colors as $color) {
      $color = check_plain($color);
      $choosers[] = '<span class="color-chooser" style="background-color:' . $color . '">' . $color . '</span>';
    }
    $color_chooser = '<div class="theme-color-choosers">' . implode('', $choosers) . '</div>';
  }
  
  $form['markerly_visibility'] = array(
    '#type' => 'radios',
    '#title' => t('Show Markerly on specific pages'),
    '#options' => array(
      BLOCK_VISIBILITY_NOTLISTED => t('All pages except those listed'),
      BLOCK_VISIBILITY_LISTED => t('Only the listed pages'),
    ),
    '#default_value' => variable_get('markerly_visibility', BLOCK_VISIBILITY_NOTLISTED),
  );
  $form['markerly_pages'] = array(
    '#type' => 'textarea',
    '#title' => '<span class="element-invisible">' . t('Pages') . '</span>',
    '#default_value' => variable_get('markerly_pages', "admin\nadmin/*\nnode/add\nnode/add/*\nnode/*/edit\ntaxonomy/term/*/edit"),
    '#description' => t("Specify pages by using their paths. Enter one path per line. The '*' character is a wildcard. Example paths are %blog for the blog page and %blog-wildcard for every personal blog. %front is the front page.", array('%blog' => 'blog', '%blog-wildcard' => 'blog/*', '%front' => '<front>')),
  );
  
  
  $form['color_choosers'] = array(
    '#prefix' => '<div id="color-pickers">',
    '#suffix' => '</div>',
    'color_chooser' => array(
      '#type' => 'markup',
      '#markup' => $color_chooser,
    ),
  );
  
  $form['markerly_settings'] = array(
    '#type' => 'fieldset',
    '#title' => t('Markerly settings'),
    '#tree' => TRUE,
    '#collapsible' => TRUE,
    '#attributes' => array('class' => array('markerly-settings-form')),
    '#element_validate' => array('markerly_settings_array_validate'),
  );
  
  // General settings
  $form['markerly_settings']['general_settings'] = array(
    '#markup' => '<h3>' . t('General') . '</h3>',
  );
  
  $form['markerly_settings']['pub_id'] = array(
    '#type' => 'textfield',
    '#size' => 40,
    '#title' => 'Pub ID',
    '#default_value' => $settings['pub_id'],
  );
  $form['markerly_settings']['services'] = array(
    '#type' => 'checkboxes',
    '#title' => 'Services',
    '#options' => _markerly_services(),
    '#default_value' => explode(',', $settings['services']),
  );
  // Colors
  $form['markerly_settings']['color_picker'] = array(
    '#prefix' => '<div id="markerly-colorpicker">',
    '#suffix' => '</div>',
  );
  $form['markerly_settings']['service_color'] = array(
    '#type' => 'textfield',
    '#title' => t('Service color'),
    '#size' => 6,
    '#attributes' => array('class' => array('colorpicker-input')),
    '#default_value' => '#' . $settings['service_color'],
    '#description' => $color_chooser,
  );
  $form['markerly_settings']['highlight_color'] = array(
    '#type' => 'textfield',
    '#title' => t('Highlight color'),
    '#size' => 6,
    '#attributes' => array('class' => array('colorpicker-input')),
    '#default_value' => '#' . $settings['highlight_color'],
    '#description' => $color_chooser,
  );
  $form['markerly_settings']['text_color'] = array(
    '#type' => 'textfield',
    '#title' => t('Text color'),
    '#size' => 6,
    '#attributes' => array('class' => array('colorpicker-input')),
    '#default_value' => '#' . $settings['text_color'],
    '#description' => $color_chooser,
  );
  $form['markerly_settings']['tip_style'] = array(
    '#type' => 'select',
    '#title' => t('Tip style'),
    '#options' => array(
      'light' => t('Light'),
      'dark' => t('Dark'),
      'transparent' => t('Transparent'),
    ),
    '#default_value' => $settings['tip_style'],
  );
  $form['markerly_settings']['container_restrict'] = array(
    '#type' => 'textfield',
    '#size' => 40,
    '#title' => t('Container restrict'),
    '#default_value' => $settings['container_restrict'],
    '#description' => t('CSS class of a page element outside which Markerly will not operate on highlighted text and images.'),
  );
  $form['markerly_settings']['sidebar_sharing'] = array(
    '#type' => 'checkbox',
    '#title' => t('Sidebar sharing'),
    '#default_value' => $settings['sidebar_sharing'],
  );
  
  // Highlighted Text
  $form['markerly_settings']['text_settings'] = array(
    '#markup' => '<h3>' . t('Highlighted Text') . '</h3>',
  );
  $form['markerly_settings']['text_sharing'] = array(
    '#type' => 'checkbox',
    '#title' => 'Show widget',
    '#default_value' => $settings['text_sharing'],
  );
  $form['markerly_settings']['copy_link_sharing'] = array(
    '#type' => 'checkbox',
    '#title' => 'Include link',
    '#default_value' => $settings['copy_link_sharing'],
  );
  $form['markerly_settings']['copy_link'] = array(
    '#type' => 'textfield',
    '#size' => 40,
    '#title' => 'Link text',
    '#description' => t('Example: "Read more at {{link}}"'),
    '#default_value' => $settings['copy_link'],
  );
  
  // Image settings
  $form['markerly_settings']['image_settings'] = array(
    '#markup' => '<h3>' . t('Images') . '</h3>',
  );
  $form['markerly_settings']['image_sharing'] = array(
    '#type' => 'checkbox',
    '#title' => 'Show widget',
    '#default_value' => $settings['image_sharing'],
  );
  $form['markerly_settings']['image_sharing_position'] = array(
    '#type' => 'select',
    '#title' => t('Widget position'),
    '#options' => array(
      'nw' => t('Upper left'),
      'ne' => t('Upper right'),
      'sw' => t('Lower left'),
      'se' => t('Lower right'),
    ),
    '#default_value' => $settings['image_sharing_position'],
  );
  $form['markerly_settings']['image_services'] = array(
    '#type' => 'checkboxes',
    '#title' => 'Image services',
    '#options' => _markerly_services('image'),
    '#default_value' => explode(',', $settings['image_services']),
  );
  $form['markerly_settings']['image_sharing_exclude'] = array(
    '#type' => 'textfield',
    '#size' => 40,
    '#title' => t('Exclude class'),
    '#default_value' => $settings['image_sharing_exclude'],
    '#description' => t('CSS selector to exclude from image sharing, e.g. "site-logo".'),
  );
    
  drupal_add_js(drupal_get_path('module', 'markerly') . '/markerly.admin.js');
  drupal_add_library('system', 'farbtastic');
  drupal_add_css(drupal_get_path('module', 'markerly') . '/markerly.admin.css');
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Save configuration'),
  );
  
  $form['#submit'] = array('markerly_settings_submit');

  return $form;

}

function markerly_settings_submit($form, $form_state) {
  variable_set('markerly_visibility', $form_state['values']['markerly_visibility']);
  variable_set('markerly_pages', $form_state['values']['markerly_pages']);
  if (!empty($form_state['values']['markerly_settings'])) {
    variable_set('markerly_settings', $form_state['values']['markerly_settings']);
  }
}

function markerly_settings_array_validate($element, &$form_state, $form) {
  foreach (array('services', 'image_services') as $field) {
    $form_state['values']['markerly_settings'][$field] = implode(',', array_filter($form_state['values']['markerly_settings'][$field]));
  }
  foreach (array('service_color', 'highlight_color', 'text_color') as $field) {
    $value = str_replace('#', '', $form_state['values']['markerly_settings'][$field]);
    if (!empty($value) && (strlen($value) != 6 || !preg_match('|^[0-9a-fA-F]+$|', $value))) {
      form_error($element[$field], t('Colors must be in hexadecimal format.'));
    }
    else {
      $form_state['values']['markerly_settings'][$field] = $value;
    }
  }
}

function _markerly_services($context = '') {
  $services = array(
    'facebook' => t('Facebook'),
    'twitter' => t('Twitter'),
    'email' => t('Email'),
    'pinterest' => t('Pinterest'),
    'evernote' => t('Evernote'),
    'linkedin' => t('LinkedIn'),
    'googleplus' => t('Google+'),
    'comments' => t('Comments'),
  );
  if ($context == 'image') {
    unset ($services['evernote']);
    unset ($services['linkedin']);
  }
  return $services;
}
