<?php

/**
 * Admin settings, see INSTALL.txt
 */
function bakery_settings($form, &$form_state) {
  $form = array(
    '#submit' => array('bakery_settings_submit'),
  );

  $form['bakery_is_master'] = array(
    '#type' => 'checkbox',
    '#title' => 'Is this the master site?',
    '#default_value' => variable_get('bakery_is_master', 0),
    '#description' => t('On the master site, accounts need to be created by traditional processes, i.e by a user registering or an admin creating them.'),
  );

  $form['bakery_master'] = array(
    '#type' => 'textfield',
    '#title' => 'Master site',
    '#default_value' => variable_get('bakery_master', 'http://drupal.org/'),
    '#description' => t('Specify the master site for your bakery network.'),
  );

  $form['bakery_slaves'] = array(
    '#type' => 'textarea',
    '#title' => 'Slave sites',
    '#default_value' => implode("\n", variable_get('bakery_slaves', array())),
    '#description' => t('Specify any slave sites in your bakery network that you want to update if a user changes email or username on the master. Enter one site per line, in the form "http://sub.example.com/".'),
  );

  $form['bakery_help_text'] = array(
    '#type' => 'textarea',
    '#title' => 'Help text for users with synch problems.',
    '#default_value' => variable_get('bakery_help_text', 'Otherwise you can contact the site administrators.'),
    '#description' => t('This message will be shown to users if/when they have problems synching their accounts. It is an alternative to the "self repair" option and can be blank.'),
  );

  $form['bakery_freshness'] = array(
    '#type' => 'textfield',
    '#title' => 'Seconds of age before a cookie is old',
    '#default_value' => variable_get('bakery_freshness', '3600'),
  );

  $form['bakery_key'] = array(
    '#type' => 'textfield',
    '#title' => 'Private key for cookie validation',
    '#default_value' => variable_get('bakery_key', ''),
  );

  $form['bakery_domain'] = array(
    '#type' => 'textfield',
    '#title' => 'Cookie domain',
    '#default_value' => variable_get('bakery_domain', ''),
  );

  $default = variable_get('bakery_supported_fields', array('mail' => 'mail', 'name' => 'name'));
  $default['mail'] = 'mail';
  $default['name'] = 'name';
  $options = array('name' => t('username'), 'mail' => t('e-mail'), 'status' => t('status'), 'picture' => t('user picture'), 'language' => t('language'), 'signature' => t('signature'),);
  if (module_exists('profile')) {
    $result = db_query('SELECT name, title FROM {profile_field} ORDER BY category, weight');
    foreach ($result as $field) {
      $options[$field->name] = check_plain($field->title);
    }
  }
  $form['bakery_supported_fields'] = array(
    '#type' => 'checkboxes',
    '#title' => 'Supported profile fields',
    '#default_value' => $default,
    '#options' => $options,
    '#description' => t('Choose the profile fields that should be exported by the master and imported on the slaves. Username and E-mail are always exported. The correct export of individual fields may depend on the appropriate settings for other modules on both master and slaves. You need to configure this setting on both the master and the slaves.'),
  );

  // Tell system_settings_form() to not set default_values since we have already done so.
  return system_settings_form($form, FALSE);
}

function bakery_settings_submit($form, &$form_state) {
  // Rebuild the menu because the router items are based on the selection of
  // the master site. (Rebuilding it immediately here would be too early,
  // because the 'bakery_is_master' variable doesn't get set until the next
  // submit handler runs. So we trigger a rebuild on the next page request
  // instead.)
  variable_set('menu_rebuild_needed', TRUE);

  // Updating of data on slave sites will not work unless the url of the master site has a trailing slash.
  // We now remove the trailing slash (if present) and concatenate with a new trailing slash.
  $form_state['values']['bakery_master'] = trim($form_state['values']['bakery_master'], '/') .'/';

  // The list of slave sites needs transforming from a text string into array for storage.
  // Also, redirection after login will only work if there is a trailing slash after each entry.
  if ($form_state['values']['bakery_slaves']) {
    // Transform the text string into an array.
    $form_state['values']['bakery_slaves'] = explode("\n", trim(str_replace("\r", '', $form_state['values']['bakery_slaves'])));
    // For each entry, remove the trailing slash (if present) and concatenate with a new trailing slash.
    foreach ($form_state['values']['bakery_slaves'] as &$slave) {
      $slave = trim($slave, '/') .'/';
    }
  }
  else {
    $form_state['values']['bakery_slaves'] = array();
  }
}

/**
 * Form for admins to pull accounts.
 */
function bakery_pull_form($form, &$form_state) {

  $form['or_email'] = array(
    '#type' => 'radios',
    '#options' => array(
      0 => t('Username'),
      1 => t('Username or email'),
    ),
    '#default_value' => 0,
  );
  $form['name'] = array(
    '#type' => 'textfield',
    '#required' => TRUE,
  );

  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Request account'),
  );

  return $form;
}

/**
 * Make sure we are not trying to request an existing user.
 */
function bakery_pull_form_validate($form, &$form_state) {
  $existing_account = user_load_by_name($form_state['values']['name']);
  if (!$existing_account && $form_state['values']['or_email']) {
    $existing_account = user_load_by_mail($form_state['values']['name']);
  }
  // Raise an error in case the account already exists locally.
  if ($existing_account) {
    form_set_error('name', t('Account !link exists.', array('!link' => theme('username', array('account' => $existing_account)))));
  }
}

/**
 * If the request succeeds, go to the user page. Otherwise, show an error.
 */
function bakery_pull_form_submit($form, &$form_state) {
  $result = bakery_request_account($form_state['values']['name'], $form_state['values']['or_email']);
  if ($result === FALSE) {
    drupal_set_message(t("Pulling account %name failed: maybe there is a typo or they don't exist on the master site.", array('%name' => $form_state['values']['name'])), 'error');
  }
  else {
    $form_state['redirect'] = 'user/' . $result;
  }
}
