<?php
/**
 * @file
 * Ban User - administration forms.
 */

/**
 * Form constructor for the ban user settings form.
 *
 * Path: admin/user/settings/ban-user
 *
 * @see ban_user_menu()
 *
 * @ingroup forms
 */
function ban_user_settings_form($form_state) {
  global $base_url;

  $form = array();

  $form['ban_user_message'] = array(
    '#type' => 'textarea',
    '#title' => t('Message for a banned user'),
    '#default_value' => variable_get('ban_user_message', t('This account has been temporarily suspended. You will be able to access the site again on [ban-deadline].')),
    '#description' => t('Avilable token is [ban-deadline].'),
    '#rows' => 5,
  );
  $date_formats = array(
    'short' => variable_get('date_format_short', 'Y-m-d H:i'),
    'medium' => variable_get('date_format_medium', 'D, Y-m-d H:i'),
    'long' => variable_get('date_format_long', 'l, F j, Y - H:i'),
  );
  $form['ban_user_date_format'] = array(
    '#type' => 'select',
    '#title' => t('Preferred date format'),
    '#description' => t('You can edit the formats in <a href="!date-format">Date and Time Settings.</a>', array(
      '!date-format' => url('admin/settings/date-time'),
      )),
    '#options' => $date_formats,
    '#default_value' => variable_get('ban_user_date_format', 'medium'),
  );

  return system_settings_form($form);
}
