<?php

namespace Drupal\banana_dashboard\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Banana dashboard settings for this site.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'banana_dashboard_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['banana_dashboard.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['icon_library'] = [
        '#type' => 'select',
        '#title' => $this->t('Icon Library'),
        '#default_value' => $this->config('banana_dashboard.settings')->get('icon_library'),
        '#options' => [
          'fontawesome' => 'Fontawesome',
          'line_awesome' => 'Line Awesome',
        ],
        '#description' => $this->t('The Icon library is not a direct dependency for "Banana Dashboard" module.<br/>
            Make sure that the library is available on `/admin/banana-dashboard`.<br/>
            Visit  Icon Library projects for <a href="https://www.drupal.org/project/fontawesome">fontawesome</a> or
            <a href="https://www.drupal.org/project/line_awesome">line_awesome</a>
            to learn more about how to install and enable the library.'),
      ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('banana_dashboard.settings')
      ->set('icon_library', $form_state->getValue('icon_library'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
