
## SUMMARY

Banana Dashboard is a developer tool to create a page with bunch of icons with links.

There is no admin UI or feature exports. The configuration is stored in a yaml file.

By implementing `hook_banana_dashboard_yaml_file_path_alter`, you can specify the location of yaml file from which the module creates the "dashboard".

For a full description of the module, visit the
  [Banana Dashboard project page on Drupal.org](http://drupal.org/project/banana_dashboard)

To submit bug reports and feature suggestions, or to track changes please visit 
  [Issues for Banana Dashboard on Drupal.org](http://drupal.org/project/issues/banana_dashboard)


## REQUIREMENTS

Drupal modules

 - [yaml_parser](https://www.drupal.org/project/yaml_parser)
 - [fontawesome](https://www.drupal.org/project/fontawesome)

External Libraries
 - spyc (required by yaml_parser drupal module).
 - fontawesome (required by fontawesome drupal module).

## INSTALLATION

* Install as usual, see https://www.drupal.org/docs/7/extending-drupal-7/installing-drupal-7-contributed-modules for further information.

## CONFIGURATION

* Implement the `hook_banana_dashboard_yaml_file_path_alter` in your custom
module and change the filepath to point to your custom yaml configuration file.
  Following keys are supported. Refer to example banana_dashboard.yaml file
  included in module for more details about configuration.

  - dashboard : Dashboard menu item definition.
  - dashboard_menu_groups : Group headings for individual links in Dashboard.
  - dashboard_menu : Individual links to be exposed on dashboard.


## CUSTOMIZATION


## TROUBLESHOOTING

* If no icons shows up in Dashboard:

  - Check if Fontawesome library is installed properly.


## FAQ

Q: Where is the dashboard located?

A: There is no default path for dashboard url. However you can provide through
  the yaml configuraiton file as such.
  Example :
  
  ```
  dashboard:
    url: admin/dashboard
    title: Dashboard
    access arguments:
      - access administration pages
  ```


Q: How can i configure the dashboard?

A: Implement the `hook_banana_dashboard_yaml_file_path_alter` in your custom
module and change the filepath to point to your custom yaml configuration file.


## CONTACT

Current maintainers:

* Shibin Das (D34dMan) - https://www.drupal.org/user/751698

---

This project has been sponsored by:

* **Factorial GmBH**
  A development studio based in Hamburg. Factorial works hand in hand with
  agencies on progressive solutions for international brands.
  Visit http://www.factorial.io for more information.

* **Om Software Solutions**
  Friendly Drupal expert providing professional consulting services.
  Visit http://oss-kerala.com for more information.
