<?php

/**
 * @file
 * Callback for admin/config/system/banckle/livechat/visibility
 */

/**
 * Form builder for the visibility form.
 *
 * @see banckle_live_chat_menu()
 *
 * @ingroup forms
 */
function _form_banckle_live_chat_admin_visibility($form, &$form_state) {
  $form["banckle_live_chat_admin_position"] = array(
    "#type" => "select",
    "#title" => "Position",
    "#description" => "",
    "#multiple" => FALSE,
    "#options" => array("top-left" => "Top left", "top-right" => "Top right", "bottom-left" => "Bottom left", "bottom-right" => "Bottom right"),
    "#default_value" => variable_get("banckle_live_chat_admin_position", "bottom-right"),
  );

  $form["banckle_live_chat_admin_user"] = array(
    "#type" => "checkbox",
    "#title" => "Allow user to hide Banckle Live Chat button for them",
    "#default_value" => variable_get("banckle_live_chat_admin_user", 0),
  );

  $form["banckle_live_chat_admin_pages"] = array(
    "#type" => "textarea",
    "#title" => "Exclude pages",
    "#description" => "Mention pages on which the Banckle Live Chat button is not visible.",
    "#default_value" => variable_get("banckle_live_chat_admin_pages", ""),
  );

  return system_settings_form($form);
}

/**
 * Form submission handler for the visibility form.
 */
function _form_banckle_live_chat_admin_visibility_submit($form, &$form_state) {
  variable_set("banckle_live_chat_admin_user", intval($form_state["values"]["banckle_live_chat_admin_user"]));
  variable_set("banckle_live_chat_admin_pages", $form_state["values"]["banckle_live_chat_admin_pages"]);
  variable_set("banckle_live_chat_admin_position", $form_state["values"]["banckle_live_chat_admin_position"]);
}
