<?php

namespace Drupal\bankid;

use Drupal\Core\Site\Settings;
use Drupal\Core\Database\Connection;
use Drupal\user\UserStorageInterface;
use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Password\DefaultPasswordGenerator;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A base class to help developers implement their own sandwich plugins.
 *
 * @see \Drupal\bankid\Annotation\Integration
 * @see \Drupal\bankid\IntegrationInterface
 */
abstract class IntegrationBase extends PluginBase implements IntegrationInterface, ContainerFactoryPluginInterface {

  /**
   * The immutable configuration.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected $config;

  /**
   * The user storage.
   *
   * @var \Drupal\Core\Entity\EntityStorageInterface
   */
  protected $userStorage;

  /**
   * The password generator.
   *
   * @var \Drupal\user\DefaultPasswordGenerator
   */
  protected $passwordGenerator;

  /**
   * The database connection.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $connection;

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, ConfigFactoryInterface $config_factory, UserStorageInterface $user_storage, DefaultPasswordGenerator $password_generator, Connection $connection) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->config = $config_factory->get('bankid.settings');
    $this->userStorage = $user_storage;
    $this->passwordGenerator = $password_generator;
    $this->connection = $connection;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('config.factory'),
      $container->get('entity_type.manager')->getStorage('user'),
      $container->get('password_generator'),
      $container->get('database')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getLabel() {
    return $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function getUser(string $response) {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function createUser(string $response) {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function hash(string $str) {
    return hash('sha256', $str . Settings::get('hash_salt', ''));
  }

}
