<?php

namespace Drupal\bankid;

/**
 * An interface for all Integration type plugins.
 */
interface IntegrationInterface {

  /**
   * Provide the Integration label.
   *
   * @return string
   *   A string label of the Integration.
   */
  public function getLabel();

  /**
   * Get the user from the response.
   *
   * @param string $response
   *   The response from the BankID service.
   *
   * @return \Drupal\user\UserInterface|null
   *   The user object.
   */
  public function getUser(string $response);

  /**
   * Create the user from the response.
   *
   * @param string $response
   *   The response from the BankID service.
   *
   * @return \Drupal\user\UserInterface|null
   *   The user object.
   */
  public function createUser(string $response);

  /**
   * Get the hash of a string.
   *
   * @param string $str
   *   The string to hash.
   *
   * @return string
   *   The hashed string.
   */
  public function hash(string $str);

}
