<?php

namespace Drupal\bankid\Plugin\BankID;

use Drupal\bankid\IntegrationBase;

/**
 * Provides default integration.
 *
 * @Integration(
 *   id = "default",
 *   label = @Translation("Default integration.")
 * )
 */
class DefaultIntegration extends IntegrationBase {

  /**
   * {@inheritdoc}
   */
  public function getUser(string $response) {
    $r_array = json_decode($response, TRUE);
    $ssn = $r_array['completionData']['user']['personalNumber'];
    $uid = $this->connection->select('bankid_mapping', 'b')
      ->fields('b', ['uid'])
      ->condition('id', $this->hash($ssn))
      ->execute()
      ->fetchField();

    if ($uid) {
      return $this->userStorage->load($uid);
    }

    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function createUser(string $response) {
    $r_array = json_decode($response, TRUE);
    $ssn = $r_array['completionData']['user']['personalNumber'];
    $user_name = $r_array['completionData']['user']['givenName'] . ' ' . $r_array['completionData']['user']['surname'];
    $ssn_hash = $this->hash($ssn);

    // Check if the user id (ssn) already exists.
    $uid = $this->connection->select('bankid_mapping', 'b')
      ->fields('b', ['uid'])
      ->condition('id', $ssn_hash)
      ->execute()
      ->fetchField();

    // If the user ID exists, return the user.
    if ($uid) {
      return $this->userStorage->load($uid);
    }

    // Check if the user name already exists.
    while ($user = user_load_by_name($user_name)) {
      $int = preg_replace('/[^0-9]/', '', $user_name);
      $new_name = trim(preg_replace('/[0-9]+/', '', $user_name));
      $user_name = $new_name . ' ' . ((integer) $int + 1);
    }

    // Create a new user.
    $user = $this->userStorage->create();
    $user->setUsername($user_name)
      ->setPassword($this->passwordGenerator->generate())
      ->enforceIsNew()
      ->activate()
      ->save();

    // Insert the user id (ssn) and uid into the bankid_mapping table.
    $this->connection->insert('bankid_mapping')
      ->fields([
        'uid' => $user->id(),
        'id' => $ssn_hash,
      ])
      ->execute();

    return $user;
  }

}
