<?php

namespace Drupal\bankid\Plugin\Validation\Constraint;

use Drupal\Core\Database\Connection;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\user\Plugin\Validation\Constraint\ProtectedUserFieldConstraintValidator;
use Drupal\user\UserStorageInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Validator\Constraint;

/**
 * Decorates the ProtectedUserFieldConstraint constraint.
 */
class BankIDProtectedUserFieldConstraintValidator extends ProtectedUserFieldConstraintValidator {

  protected Connection $connection;

  /**
   * BankIDProtectedUserFieldConstraintValidator constructor.
   */
  public function __construct(UserStorageInterface $user_storage, AccountProxyInterface $current_user, Connection $connection) {
    parent::__construct($user_storage, $current_user);
    $this->connection = $connection;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
   return new static(
     $container->get('entity_type.manager')->getStorage('user'),
     $container->get('current_user'),
     $container->get('database')
   );
  }

  /**
   * {@inheritdoc}
   */
  public function validate($items, Constraint $constraint) {
    if (!empty($items)) {
      $account = $items->getEntity();
      if ($account && $this->userRegisteredViaBankID($account->id())) {
        return;
      }
    }

    parent::validate($items, $constraint);
  }

  /**
   * Is user registered via BankID.
   */
  protected function userRegisteredViaBankID(int $id): bool {
    // TODO: Swap this once integration with External Authentication module is done.
    return $this->connection->select('bankid_mapping', 'b')
      ->fields('b', ['uid'])
      ->condition('uid', $id)
      ->execute()
      ->fetchField();
  }

}
