<?php

declare(strict_types=1);

namespace Drupal\bankid;

use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * BankID user messages.
 */
class BankIDUserMessages {

  use StringTranslationTrait;

  /**
   * BankID user messages.
   *
   * @var array
   *
   * @link https://www.bankid.com/en/utvecklare/guider/teknisk-integrationsguide/rp-anvaendarfall
   */
  protected static $messages = [
    "RFA1" => "Start your BankID app.",
    "RFA2" => "The BankID app is not installed. Please contact your bank.",
    "RFA3" => "Action cancelled. Please try again.",
    "RFA4" => "An identification or signing for this personal number is already started. Please try again.",
    "RFA5" => "Internal error. Please try again.",
    "RFA6" => "Action cancelled.",
    "RFA8" => "The BankID app is not responding. Please check that it's started and that you have internet access. If you don't have a valid BankID you can get one from your bank. Try again.",
    "RFA9" => "Enter your security code in the BankID app and select Identify or Sign.",
    "RFA13" => "Trying to start your BankID app.",
    "RFA14-A" => "Searching for BankID, it may take a little while...\n
If a few seconds have passed and still no BankID has been found, you probably don't have a BankID which can be used for this identification/signing on this computer. If you have a BankID card, please insert it into your card reader. If you don't have a BankID you can get one from your bank. If you have a BankID on another device you can start the BankID app on that device.",
    "RFA14-B" => "Searching for BankID, it may take a little while...\n
If a few seconds have passed and still no BankID has been found, you probably don't have a BankID which can be used for this identification/signing on this device. If you don't have a BankID you can get one from your bank. If you have a BankID on another device you can start the BankID app on that device.",
    "RFA15-A" => "Searching for BankID:s, it may take a little while...\n
If a few seconds have passed and still no BankID has been found, you probably don't have a BankID which can be used for this identification/signing on this computer. If you have a BankID card, please insert it into your card reader. If you don't have a BankID you can get one from your bank.",
    "RFA15-B" => "Searching for BankID, it may take a little while...\n
If a few seconds have passed and still no BankID has been found, you probably don't have a BankID which can be used for this identification/signing on this device. If you don't have a BankID you can get one from your bank.",
    "RFA16" => "The BankID you are trying to use is blocked or too old. Please use another BankID or get a new one from your bank.",
    "RFA17-A" => "The BankID app couldn't be found on your computer or mobile device. Please install it and get a BankID from your bank. Install the app from your app store or https://install.bankid.com.",
    "RFA17-B" => "Failed to scan the QR code. Start the BankID app and scan the QR code. Check that the BankID app is up to date. If you don't have the BankID app, you need to install it and get a BankID from your bank. Install the app from your app store or https://install.bankid.com.",
    "RFA18" => "Start the BankID app.",
    "RFA19" => "Would you like to identify yourself or sign with a BankID on this computer, or with a Mobile BankID?",
    "RFA20" => "Do you want to use BankID on this device or another device?",
    "RFA21" => "Identification or signing in progress.",
    "RFA22" => "Unknown error. Please try again.",
    "RFA23" => "Process your machine-readable travel document using the BankID app.",
  ];

  /**
   * Get a message by short name.
   *
   * @param string $short_name
   *   The short name of the message.
   *
   * @return string
   *   The message.
   */
  public static function getMessage(string $short_name): string {
    if (array_key_exists($short_name, self::$messages)) {
      /** @var \Drupal\Core\StringTranslation\TranslationManager $translation */
      $translation = \Drupal::service('string_translation');
      return $translation->translate(self::$messages[$short_name])->render();
    }
    return '';
  }

}
