<?php /**
 * @file
 * Contains \Drupal\bankvault\Controller\DefaultController.
 */

namespace Drupal\bankvault\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;

/**
 * Default controller for the bankvault module.
 */
class DefaultController extends ControllerBase {

  public function bankvault_test_login() {
    $settings = _bankvault_get_settings();

    if (empty($settings['enabled']) && !empty($settings['api_key'])) {
      $form = \Drupal::formBuilder()->getForm('\Drupal\user\Form\UserLoginForm', 'bankvault_testing');
      return $form;
    }
    else {
      throw new AccessDeniedHttpException();
    }
  }

}
