<?php

/**
 * @file
 * Contains \Drupal\bankvault\Form\BankvaultAdminForm.
 */

namespace Drupal\bankvault\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Element;

class BankvaultAdminForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'bankvault_admin_form';
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->config('bankvault.settings');

    foreach (Element::children($form) as $variable) {
      $config->set($variable, $form_state->getValue($form[$variable]['#parents']));
    }
    $config->save();

    if (method_exists($this, '_submitForm')) {
      $this->_submitForm($form, $form_state);
    }

    parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['bankvault.settings'];
  }

  public function buildForm(array $form, \Drupal\Core\Form\FormStateInterface $form_state) {
    $settings = _bankvault_get_settings();
    if (empty($settings['enabled'])) {
      $form['bankvault_testing'] = [
        '#markup' => t('<strong>Currently in testing mode.</strong><br />
        To access the login forms for testing go to
        <a href="/user/login/bankvault">user/login/bankvault</a> or
        place the "BankVault: User Login Testing" block on a page.')
        ];
    }

    $form['bankvault_api_key'] = [
      '#title' => t('API Key'),
      '#description' => t('Your API key for the BankVault service.'),
      '#type' => 'textfield',
      '#default_value' => $settings['api_key'],
      '#description' => t('Other settings on this form will be disabled until this is entered.'),
    ];

    $form['bankvault_enabled'] = [
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => $settings['enabled'],
      '#disabled' => empty($settings['api_key']),
      '#title' => t('Show QR code on user login forms'),
      '#prefix' => t('<label>Enable BankVault</label>'),
      '#description' => t('When ticked the QR code will appear on the live login forms. Otherwise the module will be in test mode.'),
    ];

    $form['bankvault_position'] = [
      '#type' => 'radios',
      '#options' => [
        'right' => 'Right',
        'underneath' => 'Underneath',
      ],
      '#default_value' => $settings['position'],
      '#disabled' => empty($settings['api_key']),
      '#title' => t('Where should the QR code be located on the login page?'),
    ];

    return parent::buildForm($form, $form_state);

  }

}
