<?php /**
 * @file
 * Contains \Drupal\bankvault\Plugin\Block\LoginBlock.
 */

namespace Drupal\bankvault\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides the LoginBlock block.
 *
 * @Block(
 *   id = "bankvault_login_block",
 *   admin_label = @Translation("BankVault: User Login Testing")
 * )
 */
class LoginBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    $block = [];
    $user = \Drupal::currentUser();
    $settings = _bankvault_get_settings();

    if (empty($settings['enabled']) && $delta == 'login_block') {
      if (empty($user->uid) && !(arg(0) == 'user' && !is_numeric(arg(1)))) {
        $block['subject'] = t('User login');
        $block['content'] = \Drupal::formBuilder()->getForm('user_login_block', 'bankvault_testing');
      }
    }
    return $block;
  }


}
