<?php
  header('content-type: application/x-javascript');

  $pos = (int) $_GET['pos'];
  $path = $_GET['path'];
  $max = (int) $_GET['max'];
  $tid = (int) $_GET['tid'];
  $refresh = 0;

  for ($i = 1; $i <= $max; $i++) {
    $cache_file = $path.'/.'.$i.'.banner.cache';
    if (!$fd = @fopen($cache_file, 'r+')) {
      if ($i == $max) {
        // we failed to open all cache files, try refreshing
        $refresh = 1;
      }
      continue;
    }
    // determine whether to use a blocking lock or a non-blocking lock
    if ($i < $max) {
      if (!flock($fd, LOCK_EX|LOCK_NB)) {
        @fclose($fd);
        continue;
      }
    }
    else { // last cache file, use a blocking-lock
      if (!flock($fd, LOCK_EX)) {
        // something is very wrong, try refreshing cache
        @fclose($fd);
        $refresh = 1;
        break;
      }
    }
    $contents = fread($fd, filesize($cache_file));

    $struct = unserialize($contents);
    $last_updated = $struct[2];

    $last = count($struct[0][$tid][$pos]) - 1;
    if ($last > 0) {
      $random = mt_rand(0, $last);
    }
    else {
      $random = 0;
    }
    $banner_id = $struct[0][$tid][$pos][$random];
    $this_banner = $struct[1][$tid][$banner_id];

    // add a view
    $struct[1][$tid][$banner_id]->views++;
    $struct[1][$tid][$banner_id]->total_views++;
    $struct[1][$tid][$banner_id]->day_views++;
    $struct[1][$tid][$banner_id]->week_views++;

    // once every minute update views in db
    if ($last_updated < (time() - 60)) {
      $struct[2] = time();
      $refresh = 1;
    }

    // dump back in cache
    $data = serialize($struct);
    rewind($fd);
    fwrite($fd, $data, strlen($data));
    flock($fd, LOCK_UN);
    fclose($fd);
    break;
  }

  // if needed, disable this banner
  if ($this_banner->max_views > 0 && ($this_banner->total_views + 1) >= $this_banner->max_views) {
    include_once 'includes/bootstrap.inc';
    // reached maximum views, set status (5) "blocked"
    db_query('UPDATE {banner} SET status = 5 WHERE id = %d', $banner_id);
    $refresh = 1;
  }
  else if ($this_banner->day_max_views > 0 && ($this_banner->day_views + 1) >= $this_banner->day_max_views) {
    include_once 'includes/bootstrap.inc';
    // reached day's maximum views, set status (2) "day's limit reached"
    db_query('UPDATE {banner} SET status = 2 WHERE id = %d', $banner_id);
    $refresh = 1;
  }
  else if ($this_banner->week_max_views > 0 && ($this_banner->week_views + 1) >= $this_banner->week_max_views) {
    include_once 'includes/bootstrap.inc';
    // reached week's maximum views, set status (3) "week's limit reached"
    db_query('UPDATE {banner} SET status = 3 WHERE id = %d', $banner_id);
    $refresh = 1;
  }

  if ($refresh) {
    include_once 'includes/bootstrap.inc';
    include_once 'includes/common.inc';
    // sync with all cache files
    _banner_refresh_cache();
  }

  print $this_banner->html;
?>