# BaoKey

## Introduction

BaoKey is a Drupal module that integrates OpenBAO secrets management with 
Drupal and the Key module.
It allows you to securely store and retrieve sensitive information using 
OpenBAO as a backend, while leveraging the Key module's API for seamless 
integration with other Drupal modules and services.

## Requirements

- Drupal 9 or 10
- [Key module](https://www.drupal.org/project/key)
- Access to an OpenBAO server

## Installation

1. Download and install the BaoKey module like any other Drupal module.
2. Enable the module via Drupal's admin interface or using Drush:
drush en baokey

## Configuration

1. Go `admin/config/system/baokey` to configure the OpenBAO connection settings:
- Enter the URL of your OpenBAO server
- Provide an authentication token for accessing OpenBAO

2. Create a new key using the Key module's interface (`admin/config/system/keys/add`):
- Select "OpenBAO" as the Key provider
- Enter the OpenBAO secret path where the key should be stored
- Fill in other required fields as needed

## Usage

### Using the Key module's API

Once you've created a key using the BaoKey provider, you can use the Key module's API to retrieve and manage the key:

```php
$key_repository = \Drupal::service('key.repository');
$key = $key_repository->getKey('your_key_id');
$key_value = $key->getKeyValue();
```
This will automatically fetch the key value from OpenBAO.

Using the BaoKey client directly
If you need more direct control, you can use the BaoKey client service:

```php
$baokey_client = \Drupal::service('baokey.client');
$secret = $baokey_client->readSecret('path/to/your/secret');
```


## Features
Seamless integration with the Key module
Secure storage of sensitive information in OpenBAO
Support for reading, writing, and deleting secrets in OpenBAO
Configuration form for easy setup of OpenBAO connection

## Troubleshooting
Ensure that your OpenBAO server is accessible from your Drupal site
Verify that the authentication token has the necessary permissions in OpenBAO
Check Drupal's logs for any error messages related to BaoKey operations

## Security Considerations
Always use HTTPS for communication between your Drupal site and OpenBAO
Regularly rotate your OpenBAO authentication tokens
Limit access to the BaoKey configuration page to trusted administrators
Ensure your OpenBAO instance is properly secured and follows best practices for secret management

## Contributing
Contributions to the BaoKey module are welcome! Please submit issues and pull requests on
the module's GitHub repository.

## License
This module is licensed under the GNU General Public License v2.0 or later.
