<?php

namespace Drupal\baokey;

/**
 * Interface for BaoKey client.
 */
interface BaoKeyClientInterface {

  /**
   * Reads a secret from OpenBAO.
   *
   * @param string $path
   *   The path to the secret.
   *
   * @return array|null
   *   The secret data or null if not found.
   */
  public function readSecret($path);

  /**
   * Writes a secret to OpenBAO.
   *
   * @param string $path
   *   The path to write the secret.
   * @param array $data
   *   The secret data to write.
   *
   * @return bool
   *   TRUE if successful, FALSE otherwise.
   */
  public function writeSecret($path, array $data);

  /**
   * Deletes a secret from OpenBAO.
   *
   * @param string $path
   *   The path of the secret to delete.
   *
   * @return bool
   *   TRUE if successful, FALSE otherwise.
   */
  public function deleteSecret($path);

}
