<?php

namespace Drupal\baokey\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure BaoKey settings for this site.
 */
class BaoKeySettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'baokey_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['baokey.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('baokey.settings');

    $form['url'] = [
      '#type' => 'url',
      '#title' => $this->t('OpenBAO URL'),
      '#default_value' => $config->get('url'),
      '#description' => $this->t('The URL of your OpenBAO server.'),
      '#required' => TRUE,
    ];

    $form['token'] = [
      '#type' => 'textfield',
      '#title' => $this->t('OpenBAO Token'),
      '#default_value' => $config->get('token'),
      '#description' => $this->t('The authentication token for OpenBAO.'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('baokey.settings')
      ->set('url', $form_state->getValue('url'))
      ->set('token', $form_state->getValue('token'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
