# BaoKey

## Introduction

BaoKey is a Drupal module that integrates OpenBAO secrets 'Key/Value secrets engine'  management with
Drupal and the Key module.
It allows you to securely store and retrieve sensitive information using
OpenBAO as a backend, while leveraging the Key module's API for seamless
integration with other Drupal modules and services.

## Requirements

- Drupal 9 or 10
- [Key module](https://www.drupal.org/project/key)
- Access to an OpenBAO / Hashicorp Vault server
- token

## Optional Requirements
- [Encrypt](https://www.drupal.org/project/encrypt)


## Installation
1. Download and install the BaoKey module like any other Drupal module.
2. Enable the module via Drupal's admin interface or using Drush:
drush en baokey

## Configuration
The BaoKey module requires configuration in your `settings.php` file (or `settings.local.php` for local development):

```php
$settings['vault_url'] = 'https://your-openbao-url.com';
$settings['vault_token'] = 'your-openbao-token';
```

2. Create a new key using the Key module's interface (`admin/config/system/keys/add`):
- fill in the label with the name of the key to retrieve the secret of the Vault.
- chose the Key type
- Select "Vault" as the Key provider
- Enter the Vault secret path where the key should be stored
- Fill in other required fields as needed


## Features
Seamless integration with the Key module
Secure storage of sensitive information in Vault
Support only "Key/Value secrets engine" reading secrets in OpenBAO
Configuration form for easy setup of Vault connection

## Troubleshooting
Ensure that your Vault server is accessible from your Drupal site
Verify that the authentication token has the necessary permissions in Vault
Check Drupal's logs for any error messages related to BaoKey operations

## Security Considerations
Always use HTTPS for communication between your Drupal site and OpenBAO
Regularly rotate your OpenBAO authentication tokens
Limit access to the BaoKey configuration page to trusted administrators
Ensure your OpenBAO instance is properly secured and follows best practices for secret management

## Contributing
Contributions to the BaoKey module are welcome! Please submit issues and pull requests on
the module's GitHub repository.

## License
This module is licensed under the GNU General Public License v2.0 or later.
