<?php

/**
 * @file
 * Code for the issue status admin configuration form.
 */ 

/**
  * Menu callback to configure barcode module settings.
  */
function barcode_settings() {
  $barcode = barcode_get_settings();

  $form['barcode_default_path'] = array(
    '#title' => t('Default path'),
    '#description' => t('A file system URI where the barcode images will be stored. Changing this location will cause that barcodes will be generated again upon view.'),
    '#type' => 'textfield',
    '#default_value' => $barcode['default_path'],
    '#size' => 60,
    '#required' => TRUE,
  );

  module_load_include('inc', 'barcode', 'includes/barcode.plugins');
  $plugins = barcode_discover_plugins();
  $encoding_options = array();
  foreach ($plugins as $file => $encodings) {
    $encoding_options += $encodings;
  }
  asort($encoding_options);
  $form['barcode_encoding'] = array(
    '#type' => 'select',
    '#title' => t('Encoding'),
    '#description' => t('The default encoding method used to format the barcode.'),
    '#default_value' => $barcode['encoding'],
    '#multiple' => FALSE,
    '#options' => $encoding_options,
    '#required' => TRUE,
  );

  $form['barcode_height'] = array(
    '#title' => t('Height'),
    '#description' => t('Integer! in order to scan the printed barcode, the suggested height is 30'),
    '#type' => 'textfield',
    '#default_value' => $barcode['height'],
    '#size' => 2,
    '#required' => TRUE,
  );
  $form['barcode_scale'] = array(
    '#title' => t('Scale'),
    '#description' => t('Float! in order to scan the printed barcode, the suggested height is 2.0'),
    '#type' => 'textfield',
    '#default_value' => $barcode['scale'],
    '#size' => 2,
    '#required' => TRUE,
  );
  $form['barcode_bgcolor'] = array(
    '#title' => t('Background color'),
    '#description' => t('Hex value'),
    '#type' => 'textfield',
    '#default_value' => $barcode['bgcolor'],
    '#size' => 8,
    '#required' => TRUE,
  );
  $form['barcode_barcolor'] = array(
    '#title' => t('Bar color'),
    '#description' => t('Hex value'),
    '#type' => 'textfield',
    '#default_value' => $barcode['barcolor'],
    '#size' => 8,
    '#required' => TRUE,
  );
  $form['barcode_font'] = array(
    '#title' => t('Font file'),
    '#description' => t("The font used in barcode, must be relative path to Drupal's base."),
    '#type' => 'textfield',
    '#default_value' => $barcode['font'],
    '#size' => 100,
    '#required' => TRUE,
  );
  $form['barcode_image_format'] = array(
    '#title' => t('Image format'),
    '#description' => t('The image format used for generated barcodes. Supported formats: png, gif, jpg.'),
    '#type' => 'select',
    '#default_value' => $barcode['image_format'],
    '#options' => array('png' => 'png', 'jpg' => 'jpg', 'gif' => 'gif'),
    '#maxlength' => 4,
    '#required' => TRUE,
  );

  return system_settings_form($form);
}

function barcode_settings_validate($form, &$form_state) {

  $created = file_prepare_directory($form_state['values']['barcode_default_path'], FILE_CREATE_DIRECTORY | FILE_MODIFY_PERMISSIONS);

  if (!$created) {
    form_set_error('barcode_default_path', t('Path could not be created or made writeable.'));
  }
}
