<?php
// $Id: template.php,v 1.1.2.1.2.3 2007/02/19 02:09:02 jwolf Exp $
// regions for barron 
function barron_regions() {
    return array(
        'sidebar' => t('sidebar'),
        'content_top' => t('content top'),
        'content_bottom' => t('content bottom'),
        'footer' => t('footer')
    );
}
// set delimiter for links and add icons
function barron_links($links, $delimiter = ' &bull;&nbsp;')
{
  if (!is_array($links)) {
    return '';
  }

  /* Maps a link to it's associated class */
  $link_to_id = array(
    t('edit') => 'edit',
    t('delete') => 'delete',
    t('Add a new comment.') => 'add-comment',
    t('comment') => 'comment',
    t('reply') => 'reply',
    t('Printer-friendly version.') => 'print',
    t('add child page.') => 'add-child-page',
    t('calendar.') => 'calendar',
  );

  $new_links = array();

  foreach ($links as $link) {
    foreach ($link_to_id as $text => $id) {
      if (strpos($link, $text)) {
        $link = str_replace('<a ', "<a class=\"icon-$id\" ", $link);
        break;
      }
    }
    $new_links[] = $link;
  }

  return implode($delimiter, $new_links);
}
