<?php

namespace Drupal\base_field_display\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\Plugin\Field\FieldFormatter\StringFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'plain_text' formatter.
 *
 * @FieldFormatter(
 *   id = "base_field_display_string",
 *   label = @Translation("Plain text"),
 *   field_types = {
 *     "uuid",
 *     "password",
 *   }
 * )
 */
#[FieldFormatter(
  id: 'base_field_display_string',
  label: new TranslatableMarkup('Plain text'),
  field_types: [
    'uuid',
    'password',
  ]
)]
class BaseFieldDisplayStringFormatter extends StringFormatter {
}
