(function ($, Drupal, once) {
  Drupal.behaviors.mtHeadroomGlobal = {
    attach: function (context, settings) {
      once('mtHeadroomGlobalInit', "body", context).forEach(function(item) {
        $(item).headroom({
          classes : {
            // when element is initialised
            initial : "headroom",
            // when scrolling up
            pinned : "headroom--scroll-up",
            // when scrolling down
            unpinned : "headroom--scroll-down",
            // when above offset
            top : "headroom--top",
            // when below offset
            notTop : "headroom--not-top",
            // when at bottom of scoll area
            bottom : "headroom--bottom",
            // when not at bottom of scroll area
            notBottom : "headroom--not-bottom"
          }
        });
      });
    }
  };
})(jQuery, Drupal, once);
