(function ($, Drupal, once) {
  Drupal.behaviors.mtWaypointsFixedHeader = {
    attach: function (context, settings) {
      once('mtWaypointsFixedHeaderInit', ".header-container .header", context).forEach(function(item) {
        var sticky = new Waypoint.Sticky ({
          element: $('.header-container .header')[0],
          stuckClass: 'js-fixed',
          handler: function(direction) {
            if (Waypoint.viewportWidth() > 974) {
              $('body', context).toggleClass('onscroll');
            } else {
              $('body', context).removeClass('onscroll');
            }
            var topValue = $('body').css('padding-top');
            $(".header.js-fixed").css("top", topValue);
          },
          offset: function() {
            var offsetValue = parseInt($('body').css('padding-top')) - 1;
            return offsetValue;
          }
        });
      });
    }
  };
})(jQuery, Drupal, once);
