<?php


/**
 * Implements hook_html_head_alter().
 */
function basement_html_head_alter(&$head_elements) {

  // HTML5 style charset
  $head_elements['system_meta_content_type']['#attributes'] = array(
    'charset' => 'utf-8',
  );

  foreach($head_elements as $k => $head_element) {
    // Remove default favicon. We manage that directly in page.tpl, and
    // in the 'icon' folder of the theme.
    // Theme settings page allow us to change favicon but not apple icon.
    if (strpos($k, 'drupal_add_html_head_link:shortcut icon') === 0) {
      unset($head_elements[$k]);
    }
  }

} // basement_html_head_alter


/**
 * Implements hook_js_alter().
 */
function basement_js_alter(&$js) {
  // Add themePath settings
  $js['settings']['data'][] = array('themePath' => base_path() . drupal_get_path('theme', 'basement'));

  // Remove some useless file
  $js_to_remove = array(
    'path/to/useless.js'
  );
  foreach ($js_to_remove as $js_filename) {
    if (!empty($js[$js_filename])) {
      unset($js[$js_filename]);
    }
  }
}


/**
 * Implements hook_css_alter().
 */
function basement_css_alter(&$css) {
  // Remove some useless file
  $css_to_remove = array(
    'path/to/useless.css'
  );
  foreach ($css_to_remove as $css_filename) {
    if (!empty($css[$css_filename])) {
      unset($css[$css_filename]);
    }
  }
}


/**
 * Implements hook_process_html_tag().
 * Remove useless attributes (HTML5)
 */
function basement_process_html_tag(&$vars) {
  $tag = &$vars['element'];
  if ($tag['#tag'] == 'style' || $tag['#tag'] == 'script') {
    // Remove redundant type attribute and CDATA comments.
    unset($tag['#attributes']['type'], $tag['#value_prefix'], $tag['#value_suffix']);

    // Remove media="all" but leave others unaffected.
    if (isset($tag['#attributes']['media']) && $tag['#attributes']['media'] === 'all') {
      unset($tag['#attributes']['media']);
    }
  }
}


/**
 * Implements hook_preprocess_html().
 */
function basement_preprocess_html(&$vars) {
  $path_to_theme = base_path() . drupal_get_path('theme', 'basement');

  // (fav)icon path
  $vars['icon_path'] = $path_to_theme . '/icon';

  // Viewport
  $viewport = array(
    '#tag' => "meta",
    '#attributes' => array(
      'name' => "viewport",
      'content' => "width=device-width,initial-scale=1"
    ),
  );
  drupal_add_html_head($viewport, 'viewport');

  // HTML5 Shiv
  // Must be printed
  $html5shiv = array(
    '#type' => 'html_tag',
    '#tag' => "script",
    '#prefix' => "<!--[if lt IE 9]>",
    '#value' => "",
    '#suffix' => "<![endif]-->",
    '#attributes' => array(
      'src' => "//html5shiv.googlecode.com/svn/trunk/html5.js",
    ),
  );
  drupal_add_html_head($html5shiv, 'html5shiv');

  // Respond.js
  // Could not use drupal_add_html_head() because respond.js must be
  // references after all CSS, but not in footer.
  // use render($respond);
  $vars['respond'] = array(
    '#type' => 'html_tag',
    '#tag' => "script",
    '#prefix' => "<!--[if lt IE 9]>",
    '#value' => "",
    '#suffix' => "<![endif]-->",
    '#attributes' => array(
      'src' => $path_to_theme . "/js/lib/respond.min.js",
    ),
  );

  // jQuery Placeholder
  // Could not use drupal_add_js because we target IE9- only.
  // use render($placeholder);
  $vars['placeholder'] = array(
    '#type' => 'html_tag',
    '#tag' => "script",
    '#prefix' => "<!--[if lt IE 10]>",
    '#value' => "",
    '#suffix' => "<![endif]-->",
    '#attributes' => array(
      'src' => $path_to_theme . "/js/lib/jquery.placeholder.min.js",
    ),
  );


  /**
   * <body> classes
   */

  // Remove default 'no-sidebars' class, because we don't use sidebar_(first/second)
  foreach ($vars['classes_array'] as $key => $value) {
    if ($value == 'no-sidebars') {
      unset($vars['classes_array'][$key]);
    }
  }

  // Alias classes, by virtual folders
  $alias = explode('/', drupal_get_path_alias());
  while(!empty($alias)) {
    $vars['classes_array'][] = drupal_html_class('path-'.implode('-', $alias));
    array_pop($alias);
  }

  // Node edit/add classes
  if (arg(0) == 'node') {
    if (arg(1) == 'add') {
      $vars['classes_array'][] = 'section-node-add';
    }
    elseif (is_numeric(arg(1)) && (arg(2) == 'edit' || arg(2) == 'delete')) {
      $vars['classes_array'][] = drupal_html_class('section-node-' . arg(2));
    }
  }

  // Classes for views page.
  $vars['menu_item'] = menu_get_item();
  if ($vars['menu_item']['page_callback'] == 'views_page') {
    $vars['classes_array'][] = 'page-views';
    $vars['classes_array'][] = drupal_html_class('page-views-' . $vars['menu_item']['page_arguments'][0]);
  }

  /**
   * Head title
   */

  // SEO: Append page number to title.
  if (!empty($_GET['page']) && !empty($vars['head_title'])) {
    $head_title = explode(' | ', $vars['head_title']);
    $head_title[0] .= ', page '.check_plain($_GET['page']+1);
    $vars['head_title'] = implode(' | ', $head_title);
  }

} // basement_preprocess_html


/**
 * Implements hook_preprocess_page().
 */
function basement_preprocess_page(&$vars) {

  // Remove contexutal links class from page (it makes every CL appears on page hover)
  // @TODO : check if needed.
  foreach($vars['classes_array'] as $k => $v) {
    if ($v == 'contextual-links-region') {
      unset($vars['classes_array'][$k]);
    }
  }

  // Add more template suggestions
  if (isset($vars['node'])) {
    $vars['theme_hook_suggestions'][] = 'page__node__' . $vars['node']->type;
  }

  // Tabs
  if (!empty($vars['tabs']['#primary'])) {
    $vars['classes_array'][] = 'with-tabs';
  }

  // Title (h1)
  // Do not display on page.tpl if we're viewing a node
  if (isset($vars['node']) && !isset($vars['display_title'])) {
    $vars['display_title'] = FALSE;
  }
  $vars['display_title'] = isset($vars['display_title']) ? $vars['display_title'] : TRUE;

  // Work-around a stupid bug in Drupal 7
  if (arg(0) == 'user' && arg(1) == 'login') {
    drupal_set_title(t('User login'));
  }
  if (arg(0) == 'user' && arg(1) == 'password') {
    drupal_set_title(t('Request new password'));
  }
  if (arg(0) == 'user' && arg(1) == 'register') {
    drupal_set_title(t('Create new account'));
  }

} // basement_preprocess_page


/**
 * Implements hook_preprocess_node().
 */
function basement_preprocess_node(&$vars) {
  $node = $vars['node'];

  // Add view-mode & type template suggestions and classes
  $vars['theme_hook_suggestions'][] = 'node__' . $vars['view_mode'];
  $vars['theme_hook_suggestions'][] = 'node__' . $node->type . '__' . $vars['view_mode'];
  $vars['classes_array'][] = drupal_html_class('node-' . $vars['view_mode']);
  $vars['classes_array'][] = drupal_html_class('node-' . $node->type . '-' . $vars['view_mode']);

  // HTML5 submitted info
  $vars['datetime'] = format_date($node->created, 'custom', 'c');
  if ($vars['display_submitted']) {
    $vars['submitted'] = t("Submitted by !username on !datetime",
      array(
        '!username' => $vars['name'],
        '!datetime' => '<time datetime="' . $vars['datetime'] . '" pubdate="pubdate">' . $vars['date'] . '</time>',
      )
    );
  }
  else {
    $vars['submitted'] = '';
  }

  // h1 title is displayed on node.tpl, duplicate page.tpl id & class
  if (node_is_page($node)) {
    $vars['title_attributes_array']['id'] = 'page-title';
    $vars['title_attributes_array']['class'] = 'title';
  }

} // basement_preprocess_node


/**
 * Implements hook_preprocess_entity().
 * Provided by Entity API module.
 */
function basement_preprocess_entity(&$vars) {

}


/**
 * Implements hook_preprocess_taxonomy_term().
 */
function basement_preprocess_taxonomy_term(&$vars) {
  $term = $vars['term'];

  // Custom classes
  $vars['classes_array'][] = drupal_html_class('taxonomy-term--' . $vars['view_mode']);
  $vars['classes_array'][] = drupal_html_class('taxonomy-term--' . $vars['vocabulary_machine_name']);
}


/**
 * Implements hook_preprocess_block().
 */
function basement_preprocess_block(&$vars) {
  $block = $vars['block'];

  // Add more classes
  $vars['classes_array'][] = drupal_html_class('block-'.$vars['block_zebra']);
  $vars['classes_array'][] = drupal_html_class('block-'.$vars['block_id']);
  $vars['classes_array'][] = $vars['block_html_id'];

  // Block title
  if(empty($vars['block']->subject)) {
    // Add a class to provide CSS for blocks without titles.
    $vars['classes_array'][] = 'block-without-title';
  }
  else {
    // Adding a class to the title attributes
    $vars['title_attributes_array']['class'][] = 'title';
  }

  // Use content_classes variable to add classes to content
  $vars['content_classes'] = '';
  if (isset($block->content_classes)) {
    $vars['content_classes'] = ' ' . implode(' ', $block->content_classes);
  }
  
  // @TODO add aria role support (see zen and adaptivetheme)

} // basement_preprocess_block


/**
 * Implements template_preprocess_field().
 */
function basement_preprocess_field(&$vars) {
  /*
   * theme_hook_suggestion:
   *  $variables['theme_hook_suggestions'] = array(
        'field__' . $element['#field_type'],
        'field__' . $element['#field_name'],
        'field__' . $element['#bundle'],
        'field__' . $element['#field_name'] . '__' . $element['#bundle'],
  );
   * ex: field__field_faq_question
   * ex: field__field_faq_question__field_faq (here, bundle = field_collection field
   * ex: field__field_faq_answer
   */

  $element = $vars['element'];

  // Global class for long text elements
  $field_type_text = array(
    'text',
    'text_long',
    'text_with_summary'
  );
  if (in_array($element['#field_type'], $field_type_text)) {
    $vars['classes_array'][] = 'long-text';
  }

  // Custom theme_hook_suggestions (no_markup & wrapper_only)
  $wrapper_only_fields = array('field_myexample_field');
  if (in_array($element['#field_name'], $wrapper_only_fields)) {
    $vars['theme_hook_suggestions'][] = 'field__wrapper_only';
  }

  $no_markup_fields = array('field_myexample_field');
  if (in_array($element['#field_name'], $no_markup_fields)) {
    $vars['theme_hook_suggestions'][] = 'field__no_markup';
  }

} // basement_preprocess_field


/**
 * Implements template_preprocess_search_block_form().
 * Changes the search form to use the HTML5 "search" input attribute
 */
function basement_preprocess_search_block_form(&$vars) {
  $vars['search_form'] = str_replace('type="text"', 'type="search"', $vars['search_form']);
}


/**
 * Implements theme_breadcrumb().
 */
function basement_breadcrumb($vars) {
  if (!empty($vars['breadcrumb'])) {

    // Provide a navigational heading to give context for breadcrumb links to
    // screen-reader users. Make the heading invisible with .element-invisible.
    $output = '<h2 class="element-invisible">' . t("You are here") . '</h2>';
    // Output breadcrumb as list for a11y
    $output .= '<ul><li>' . implode('</li><li>', $vars['breadcrumb']) . '</li></ul>';
    return $output;
  }
}
