<?php

$plugin = array(
  'label' => 'Node',
  'handler' => array(
    'class' => 'BasePerfNode',
  ),
);

class BasePerfNode extends BasePerf {

  function nodeTypesInfo() {
    $types = node_get_types();
    foreach ($types as $name => $type) {
      $types[$name]->count = db_result(db_query("SELECT count(nid) FROM node WHERE type = '%s'", $name));
    }
    return $types;
  }

  function configForm() {
    $types = $this->nodeTypesInfo();
    $default_value = current($types)->count;
    foreach ($types as $name => $type) {
      $options[$name] = t('!type (!count)', array('!type' => $type->name, '!count' => $type->count));
      $default_value = min($default_value, $type->count);
    }
    $form['type'] = array(
      '#type' => 'radios',
      '#title' => t('Load nodes of type'),
      '#description' => t('The number in parenthesis indicates the number of nodes in database.'),
      '#options' => $options,
      '#required' => TRUE,
    );
    $form['order'] = array(
      '#type' => 'radios',
      '#title' => t('Which nodes to pick?'),
      '#options' => array(
        'ASC' => t('First ones'),
        'DESC' => t('Last ones'),
        'both' => t('Half and half'),
      ),
      '#default_value' => 'both',
      '#required' => TRUE,
    );
    $form['count'] = array(
      '#type' => 'textfield',
      '#title' => t('How much nodes?'),
      '#default_value' => $default_value,
      '#required' => TRUE,
    );
    $form['render'] = array(
      '#type' => 'checkbox',
      '#title' => t('Render the nodes'),
      '#default_value' => FALSE,
    );

    return $form;
  }

  function configFormValidate($form, &$values) {
    if (form_get_errors()) return;
    $types = $this->nodeTypesInfo();
    if (((int) $values['count']) > ((int) $types[$values['type']]->count)) {
      form_error($form['count'], t('Number of nodes selected is greater than existing nodes.'));
    }
  }

  function execute($config) {
    if ($config['order'] != 'both') {
      $nids = $this->getNids($config['type'], $config['count'], $config['order']);
    }
    else {
      $nids1 = $this->getNids($config['type'], floor($config['count'] / 2), 'ASC');
      $nids2 = $this->getNids($config['type'], ceil($config['count'] / 2), 'DESC');
      $nids = array_merge($nids1, $nids2);
    }
    foreach ($nids as $nid) {
      $node = node_load($nid);
      if ($config['render']) {
        node_view($node);
      }
    }
  }

  function getNids($type, $count, $order) {
    $query = "SELECT nid FROM node WHERE type = '%s' ORDER BY nid $order LIMIT %d";
    $result = db_query($query, $type, $count);
    foreach ($result as $row) {
      $nids[] = $row['nid'];
    }
    return $nids;
  }
}

