<?php

namespace Drupal\basic_layouts\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Basic Layouts settings for this site.
 */
class BasicLayoutsConfig extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'basic_layouts_basic_layouts_config';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['basic_layouts.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['unset_core_layouts'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Unset core layouts?'),
      '#default_value' => $this->config('basic_layouts.settings')->get('unset_core_layouts') ?? TRUE,
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('basic_layouts.settings')
      ->set('unset_core_layouts', $form_state->getValue('unset_core_layouts'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
