<?php

namespace Drupal\basic_layouts\Plugin\Layout;

use Drupal\Core\Layout\LayoutDefault;
use Drupal\Core\Plugin\PluginFormInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * Basic layout class.
 */
class BasicLayout extends LayoutDefault implements PluginFormInterface {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return parent::defaultConfiguration() + [
      'use_intro_text' => FALSE,
      'intro' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);

    // Checkbox whether or not to add intro text at the top of the section.
    $form['use_intro_text'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Display text at the top of the section'),
      '#default_value' => $this->configuration['use_intro_text'] ?? FALSE,
    ];

    // Optional intro text field.
    $form['intro'] = [
      '#type' => 'text_format',
      '#title' => $this->t('Intro'),
      '#format' => $this->configuration['intro']['format'] ?? 'full_html',
      '#default_value' => $this->configuration['intro']['value'] ?? NULL,
      '#states'   => [
        'visible' => [
          ':input[name="layout_settings[use_intro_text]"]' => ['checked' => TRUE],
        ],
      ],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

    $this->configuration['intro'] = $form_state->getValue('intro');
    $this->configuration['use_intro_text'] = $form_state->getValue('use_intro_text');
  }

  /**
   * {@inheritdoc}
   */
  public function build(array $regions) {
    $build = parent::build($regions);

    // Render the text_format field.
    if ($this->configuration['use_intro_text'] && !empty($this->configuration['intro']['value'])) {
      $build['intro'] = [
        '#type' => 'processed_text',
        '#text' => $this->configuration['intro']['value'],
        '#format' => $this->configuration['intro']['format'],
      ];
    }

    return $build;
  }

}
