var gulp = require('gulp'),
  sass = require('gulp-sass')(require('sass')),
  rename = require('gulp-rename'),
  prefix = require('gulp-autoprefixer'),
  plumber = require('gulp-plumber'),
  notify = require('gulp-notify'),
  sourcemaps = require('gulp-sourcemaps'),
  sassLint = require('gulp-sass-lint'),
  cssmin = require('gulp-cssmin');

var onError = function (err) {
  notify.onError({
    title: "Gulp",
    subtitle: "Failure!",
    message: "Error: <%= error.message %>",
    sound: "Basso"
  })(err);
  this.emit('end');
};

var sassOptions = {
  outputStyle: 'expanded'
};

// BUILD SUBTASKS
// ---------------

gulp.task('styles', function () {
  return gulp.src('scss/basic-paragraphs.scss')
    .pipe(plumber({ errorHandler: onError }))
    .pipe(sourcemaps.init())
    .pipe(sass(sassOptions))
    .pipe(prefix())
    .pipe(rename('basic-paragraphs.css'))
    .pipe(sourcemaps.write('.'))
    .pipe(gulp.dest('css'))
});

// styles-min:
gulp.task('styles-min', function () {
  return gulp.src('scss/basic-paragraphs.scss')
    .pipe(plumber({ errorHandler: onError }))
    .pipe(sass(sassOptions))
    .pipe(prefix())
    .pipe(cssmin())
    .pipe(rename('basic-paragraphs.css'))
    .pipe(gulp.dest('css'))
});

// sass-lint:
gulp.task('sass-lint', function () {
  return gulp.src('scss/**/*.scss')
    .pipe(sassLint())
    .pipe(sassLint.format())
    .pipe(sassLint.failOnError())
});

// BUILD TASKS
// ------------

// build:
gulp.task(
  'build',
  gulp.series(
    'styles'
  )
);

// watch:
gulp.task(
  'watch',
  function () {
    gulp.watch(
      'scss/**/*.scss',
      gulp.series(
        // 'sass-lint',
        'styles'
      )
    );
  });
