<?php

namespace Drupal\basicshib\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the basicshiblog entity edit forms.
 */
class basicshiblogForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $result = parent::save($form, $form_state);

    $entity = $this->getEntity();

    $message_arguments = ['%label' => $entity->toLink()->toString()];
    $logger_arguments = [
      '%label' => $entity->label(),
      'link' => $entity->toLink($this->t('View'))->toString(),
    ];

    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('New basicshiblog %label has been created.', $message_arguments));
        $this->logger('basicshib')->notice('Created new basicshiblog %label', $logger_arguments);
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus($this->t('The basicshiblog %label has been updated.', $message_arguments));
        $this->logger('basicshib')->notice('Updated basicshiblog %label.', $logger_arguments);
        break;
    }

    $form_state->setRedirect('entity.basicshiblog.canonical', ['basicshiblog' => $entity->id()]);

    return $result;
  }

}
