<?php

namespace Drupal\basket\Admin;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\InvokeCommand;
use Drupal\Core\Ajax\ReplaceCommand;
use Drupal\Core\Url;
use Drupal\Core\Render\Markup;
use Drupal\basket\Admin\ManagerMenu;
use Drupal\basket\Admin\Page\Order;
use Drupal\basket\BasketExport;
use Drupal\basket\Admin\Page\Orders;
use Drupal\basket\Admin\Page\Trash;
use Drupal\basket\Admin\Page\StatisticsBuyers;
use Drupal\basket\Admin\Page\NodeEdit;
use Drupal\basket\Admin\Page\StockProduct;
use Drupal\basket\Admin\Form\ConfirmDeleteForm;
use Drupal\basket\Admin\Page\SubPages;
use Drupal\basket\Admin\Page\StatusPage;
use Drupal\basket\Admin\Page\DeliveryPage;
use Drupal\basket\Admin\Page\PaymentPage;
use Drupal\basket\Admin\Page\CurrencyPage;
use Drupal\basket\Admin\Page\NodeTypes;
use Drupal\basket\Admin\Page\Templates;
use Drupal\basket\Plugin\views\filter\BasketOrderFilter;
use Drupal\basket\Admin\Form\TextSettingsForm;
use Drupal\basket\Admin\Operations;
use Drupal\basket\Admin\ManagerHeader;

class Pages{

	protected static $CreateLink;

	protected $basket;

	function __construct(){
		$this->basket = \Drupal::service('Basket');
	}

	public function page($page_type = 'orders', $setContent = NULL) {
		$page_subtype = $page_subtype1 = NULL;
		if(strpos($page_type, '-') !== FALSE) 		@list($page_type, $page_subtype, $page_subtype1) = explode('-', $page_type);
		$element = [
			'#theme'		=> 'basket_admin_page',
			'#info'			=> [
				'menu'			=> ManagerMenu::block(),
				'header'		=> [],
				'content'		=> [
					'add_block'		=> $this->addBlockLine()
				]
			]
		];
		switch($page_type){
			case'orders':
				switch($page_subtype){
					case'edit':
					case'view':
						$Order = new Order($page_subtype1);
						$element['#info']['content'][] = $Order->{$page_subtype}();
					break;
					case'add':
						$Order = new Order('NEW');
						$element['#info']['content'][] = $Order->edit();
					break;
					case'waybill':
						$element['#info']['content'][] = $this->basket->Waybill($page_subtype1)->getPDFView();
					break;
					case'export':
						$element['#info']['content'][] = BasketExport::run($page_subtype1);
					break;
					default:
						$element['#info']['content'][] = Orders::page();
					break;
				}
			break;
			case'trash':
				$Trash = new Trash();
				switch($page_subtype){
					case'restore':
						$element['#info']['content'][] = $Trash->restoreBath($page_subtype1);
					break;
					case'delete':
						$element['#info']['content'][] = $Trash->deleteBath($page_subtype1);
					break;
					default:
						$element['#info']['content'][] = $Trash->page();
					break;
				}
			break;
			case'statistics':
				if(!empty($page_subtype)){
					switch($page_subtype){
						case'buyers':
							if(!empty($page_subtype1)){
								switch($page_subtype1){
									case'add':
									case'edit':
										if(!\Drupal::currentUser()->hasPermission('administer users')){
											$element['#info']['content']['view'] = $this->basket->getError(403);
										} else {
											switch($page_subtype1){
												case'add':
													$entity = \Drupal::service('entity_type.manager')->getStorage('user')->create(array());
													$entity->basket_create_user = TRUE;
													$formObject = \Drupal::service('entity_type.manager')->getFormObject('user', 'register')->setEntity($entity);
													$element['#info']['content']['view'] = [
														'#prefix'		=> '<div class="basket_table_wrap">',
														'#suffix'		=> '</div>',
														'title'			=> [
															'#prefix'		=> '<div class="b_title">',
															'#suffix'		=> '</div>',
															'#markup'		=> $this->basket->Translate()->t('Add a user')
														],
														'content'		=> [
															'#prefix'		=> '<div class="b_content">',
															'#suffix'		=> '</div>',
															'form'			=> \Drupal::formBuilder()->getForm($formObject)
														]
													];
												break;
												case'edit';
													$editUser = NULL;
													$uid = \Drupal::request()->query->get('uid');
													if(!empty($uid)){
														$editUser = \Drupal::service('entity_type.manager')->getStorage('user')->load($uid);
													}
													if(empty($editUser)){
														$element['#info']['content']['view'] = $this->basket->getError(404);
													} else {
														$editUser->basket_create_user = TRUE;
														$formObject = \Drupal::service('entity_type.manager')->getFormObject('user', 'default')->setEntity($editUser);
														$element['#info']['content']['view'] = [
															'#prefix'		=> '<div class="basket_table_wrap">',
															'#suffix'		=> '</div>',
															'title'			=> [
																'#prefix'		=> '<div class="b_title">',
																'#suffix'		=> '</div>',
																'#markup'		=> $this->basket->Translate()->t('Add a user')
															],
															'content'		=> [
																'#prefix'		=> '<div class="b_content">',
																'#suffix'		=> '</div>',
																'form'			=> \Drupal::formBuilder()->getForm($formObject)
															]
														];
													}
												break;
											}
										}
									break;
								}
							} else {
								$StatisticsBuyers = new StatisticsBuyers();
								$element['#info']['content']['view'] = $StatisticsBuyers->page();
							}
						break;
					}
				}
			break;
			case'stock':
				if(!empty($page_subtype)){
					switch($page_subtype){
						case'create':
							if(!empty($page_subtype1)){
				                $NodeType = \Drupal::service('entity_type.manager')->getStorage('node_type')->load($page_subtype1);
				                if(!empty($NodeType)){
									$entity = \Drupal::entityTypeManager()
					                      				->getStorage('node')
					                      				->create(['type' => $page_subtype1]);
					                $element['#info']['content']['view'] = [
					                	'#prefix'       => '<div class="basket_table_wrap">',
	            						'#suffix'       => '</div>',
	            						'title'			=> [
	            							'#prefix'		=> '<div class="b_title">',
	            							'#suffix'		=> '</div>',
	            							'#markup'		=> $this->basket->Translate()->t('Add a product').' "'.$NodeType->label().'"'
	            						],
	            						'content'		=> [
	            							'#prefix'       => '<div class="b_content">',
	                						'#suffix'       => '</div>',
	                						'form'			=> \Drupal::service('entity.form_builder')->getForm($entity)
	            						]
					                ];
				                }
							}
						break;
						case'edit':
							if(!empty($page_subtype1)){
								$NodeEdit = new NodeEdit($page_subtype1);
								$element['#info']['content']['view'] = $NodeEdit->editPage();
				            }
						break;
						case'product':
							$StockProduct = new StockProduct();
							$element['#info']['content']['view'] = $StockProduct->page();
						break;
						case'delete':
							$element['#info']['content']['view'] = [
			                	'#prefix'       => '<div class="basket_table_wrap">',
        						'#suffix'       => '</div>',
        						'content'		=> [
        							'#prefix'       => '<div class="b_content">',
            						'#suffix'       => '</div>',
            						'form'			=> \Drupal::formBuilder()->getForm(new ConfirmDeleteForm($page_subtype1))
        						]
			                ];
						break;
					}
				}
			break;
			case'batch':
				$current_batch = _batch_current_set();
				$element['#info']['content'][] = [
					'#prefix'       => '<div class="basket_table_wrap">',
	            	'#suffix'       => '</div>',
	            	[
	            		'#prefix'		=> '<div class="b_title">',
	            		'#suffix'		=> '</div>',
	            		'#markup'		=> $current_batch['title']
	            	],[
	            		'#prefix'		=> '<div class="b_content">',
						'#suffix'		=> '</div>',
						$setContent
	            	]
				];
			break;
			case'settings':
				if(!empty($page_subtype)){
					switch($page_subtype){
						case'extra':
						case'base':
						case'statuses':
							$element['#info']['content']['view'] = SubPages::list($page_subtype);
						break;
						case'status':
						case'fin_status':
							if(!\Drupal::currentUser()->hasPermission('basket access_page '.$page_subtype)){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$StatusPage = new StatusPage();
								$element['#info']['content']['view'] = $StatusPage->table($page_subtype);
							}
						break;
						case'delivery':
							if(!\Drupal::currentUser()->hasPermission('basket access_page delivery')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$DeliveryPage = new DeliveryPage();
								$element['#info']['content']['view'] = $DeliveryPage->table();
							}
						break;
						case'payment':
							if(!\Drupal::currentUser()->hasPermission('basket access_page payment')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$PaymentPage = new PaymentPage();
								$element['#info']['content']['view'] = $PaymentPage->table();
							}
						break;
						case'text':
							if(!\Drupal::currentUser()->hasPermission('basket access_page text')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = [
									'#prefix'		=> '<div class="basket_table_wrap">',
									'#suffix'		=> '</div>',
									'content'		=> [
										'#prefix'		=> '<div class="b_content">',
										'#suffix'		=> '</div>',
										'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\TextSettingsForm')
									]
								];
							}
						break;
						case'currency':
							if(!\Drupal::currentUser()->hasPermission('basket access_page currency')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = CurrencyPage::table();
							}
						break;
						case'node_types':
							if(!\Drupal::currentUser()->hasPermission('basket access_page node_types')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = NodeTypes::table();
							}
						break;
						case'templates':
							if(!\Drupal::currentUser()->hasPermission('basket access_page template')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = Templates::page($page_subtype1);
							}
						break;
						case'templates_preview':
							if(!\Drupal::currentUser()->hasPermission('basket access_page template')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = Templates::preview($page_subtype1);
							}
						break;
						case'order_form':
							if(!\Drupal::currentUser()->hasPermission('basket access_page order_form')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = [
									'#prefix'		=> '<div class="basket_table_wrap">',
									'#suffix'		=> '</div>',
									'content'		=> [
										'#prefix'		=> '<div class="b_content">',
										'#suffix'		=> '</div>',
										'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\SettingsOrderForm')
									]
								];
							}
						break;
						case'order_page':
							if(!\Drupal::currentUser()->hasPermission('basket access_page order_page')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = [
									'#prefix'		=> '<div class="basket_table_wrap">',
									'#suffix'		=> '</div>',
									'content'		=> [
										'#prefix'		=> '<div class="b_content">',
										'#suffix'		=> '</div>',
										'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\SettingsOrderPage')
									]
								];
							}
						break;
						case'notifications':
							if(!\Drupal::currentUser()->hasPermission('basket access_page notifications')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = [
									'#prefix'		=> '<div class="basket_table_wrap">',
									'#suffix'		=> '</div>',
									'content'		=> [
										'#prefix'		=> '<div class="b_content">',
										'#suffix'		=> '</div>',
										'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\SettingsNotificationsForm')
									]
								];
							}
						break;
						case'export_orders':
							if(!\Drupal::currentUser()->hasPermission('basket access_page export_orders')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = [
									'#prefix'		=> '<div class="basket_table_wrap">',
									'#suffix'		=> '</div>',
									'content'		=> [
										'#prefix'		=> '<div class="b_content">',
										'#suffix'		=> '</div>',
										'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\SettingsExportOrdersForm')
									]
								];
							}
						break;
						case'permissions':
							if(!\Drupal::currentUser()->hasPermission('basket settings permissions rights')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = [
									'#prefix'		=> '<div class="basket_table_wrap">',
									'#suffix'		=> '</div>',
									'content'		=> [
										'#prefix'		=> '<div class="b_content">',
										'#suffix'		=> '</div>',
										'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\UserPermissionsForm')
									]
								];
							}
						break;
						case'popup_plugin':
							if(!\Drupal::currentUser()->hasPermission('basket access_page popup_plugin')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = [
									'#prefix'		=> '<div class="basket_table_wrap">',
									'#suffix'		=> '</div>',
									'content'		=> [
										'#prefix'		=> '<div class="b_content">',
										'#suffix'		=> '</div>',
										'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\PopupPluginForm')
									]
								];
							}
						break;
						case'discount_system':
						case'discount_range':
							if(!\Drupal::currentUser()->hasPermission('basket access_page discount_system')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								switch($page_subtype){
									case'discount_system':
										$element['#info']['content']['view'] = [
											'#prefix'		=> '<div class="basket_table_wrap">',
											'#suffix'		=> '</div>',
											'content'		=> [
												'#prefix'		=> '<div class="b_content">',
												'#suffix'		=> '</div>',
												'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\DiscountSystemForm')
											]
										];
									break;
									case'discount_range':
										$element['#info']['content']['view'] = [
											'#prefix'		=> '<div class="basket_table_wrap">',
											'#suffix'		=> '</div>',
											'content'		=> [
												'#prefix'		=> '<div class="b_content">',
												'#suffix'		=> '</div>',
												'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Plugin\Basket\Discount\Form\DiscountRangeForm')
											]
										];
									break;
								}
							}
						break;
						case'empty_trash':
							if(!\Drupal::currentUser()->hasPermission('basket access_page empty_trash')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = [
									'#prefix'		=> '<div class="basket_table_wrap">',
									'#suffix'		=> '</div>',
									'content'		=> [
										'#prefix'		=> '<div class="b_content">',
										'#suffix'		=> '</div>',
										'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\EmptyTrashSettingsForm')
									]
								];
							}
						break;
						case'appearance':
							if(!\Drupal::currentUser()->hasPermission('basket access_page appearance')){
								$element['#info']['content']['view'] = $this->basket->getError(403);
							} else {
								$element['#info']['content']['view'] = [
									'#prefix'		=> '<div class="basket_table_wrap">',
									'#suffix'		=> '</div>',
									'content'		=> [
										'#prefix'		=> '<div class="b_content">',
										'#suffix'		=> '</div>',
										'form'			=> \Drupal::formBuilder()->getForm('\Drupal\basket\Admin\Form\AppearanceSettingsForm')
									]
								];
							}
						break;
					}
				}
			break;
			case'api':
				$response = new AjaxResponse();
				if(!empty($page_subtype)){
					switch($page_subtype){
/*---Orders----------------------------------------------------------------------------------------------------------------*/
						case'order_change_status':
							if(!empty($_POST['orderID']) && !empty($_POST['status_type']) && !empty($_POST['set_val'])){
								$term = $this->basket->Term()->load($_POST['set_val']);
								if($term->type == $_POST['status_type']){
									if(\Drupal::currentUser()->hasPermission('basket edit_'.$_POST['status_type'].'_order_access')){
										$order = $this->basket->Orders($_POST['orderID']);
										$order->set($_POST['status_type'], $_POST['set_val']);
										$order->save();
									}
									if(!empty($term)){
										$new_html = $this->basket->textColor(
						                    $this->basket->Translate()->t($term->name),
						                    $term->color,
						                    [
						                        'class'     => ['status_'.$term->type.'_'.$_POST['orderID']]
						                    ]
						                );
										$response->addCommand(new InvokeCommand('.status_'.$_POST['status_type'].'_'.$_POST['orderID'], 'replaceWith', [render($new_html)]));
									}
								}
								if($_POST['status_type'] == 'status'){
									$block = Orders::getStatisticsBlock();
									$response->addCommand(new ReplaceCommand('.basket_admin_orders_stat_block', \Drupal::service('renderer')->render($block)));
								}
							}
						break;
						case'orders_filter_settings':
							BasketOrderFilter::ApiResponseAlter($response);
						break;
						case'orders_tabs_settings':
						case'orders_stat_block_settings':
							Orders::ApiResponseAlter($response, $page_subtype);
						break;
						case'orders':
							if(!empty($_POST['orderId'])){
								$Order = new \Drupal\basket\Admin\Page\Order($_POST['orderId']);
								$Order->ApiResponseAlter($response, $page_subtype, $page_subtype1);
							}
							if(!empty($_POST['basketItemId'])){
								$basketItem = $this->basket->loadBasketItem($_POST['basketItemId'], $_POST['orderId'] ?? NULL);
								$basketItem->orderId = $_POST['orderId'] ?? NULL;
								if(!empty($basketItem)){
									$OrderItem = $this->basket->BasketOrderItems(NULL);
									$OrderItem->ApiResponseAlter($response, $page_subtype1, $basketItem, $_POST['params'] ?? NULL);
								}
							}
						break;
/*---Text settings----------------------------------------------------------------------------------------------------------------*/
						case'text_get_translate':
						case'translation_popup':
						case'text_delete_string':
							TextSettingsForm::ApiResponseAlter($response);
						break;
/*---Terms------------------------------------------------------------------------------------------------------------------------*/
						case'create_term':
						case'edit_term':
						case'delete_term':
							if(\Drupal::currentUser()->hasPermission('basket access_page '.$_POST['type'])){
								$StatusPage = new StatusPage();
								$StatusPage->ApiResponseAlter($response);
							}
						break;
/*---Currency---------------------------------------------------------------------------------------------------------------------*/
						case'create_currency':
						case'edit_currency':
						case'delete_currency':
							if(\Drupal::currentUser()->hasPermission('basket access_page currency')){
								CurrencyPage::ApiResponseAlter($response);
							}
						break;
/*---Node type settings-----------------------------------------------------------------------------------------------------------*/
						case'add_node_type':
						case'delete_node_type':
							if(\Drupal::currentUser()->hasPermission('basket access_page node_types')){
								NodeTypes::ApiResponseAlter($response);
							}
						break;
/*---Delivery-----------------------------------------------------------------------------------------------------------*/
						case'create_delivery':
						case'edit_delivery':
							if(\Drupal::currentUser()->hasPermission('basket access_page delivery')){
								$DeliveryPage = new DeliveryPage();
								$DeliveryPage->ApiResponseAlter($response, $page_subtype);
							}
						break;
/*---Payment-----------------------------------------------------------------------------------------------------------*/
						case'create_payment':
						case'edit_payment':
							if(\Drupal::currentUser()->hasPermission('basket access_page payment')){
								$PaymentPage = new PaymentPage();
								$PaymentPage->ApiResponseAlter($response, $page_subtype);
							}
						break;
/*---Operations---------------------------------------------------------------------------------------------------------*/
						case'operations':
							$Operations = new Operations();
							$Operations->ApiResponseAlter($response, $page_subtype);
						break;
/*---Help---------------------------------------------------------------------------------------------------------------*/
						case'help':
							\Drupal::service('BasketPopup')->openModal(
			                    $response,
			                    $this->basket->Translate()->t('Functional activation'),
			                    [
		                    		'#prefix'		=> '<div class="help_content">',
		                    		'#suffix'		=> '</div>',
			                    	'#markup'		=> $this->basket->Translate()->t('To activate the functionality, write @mail@', [
			                    		'@mail@'		=> Markup::create('<a href="mailto:'.$this->basket->getMail().'">'.$this->basket->getMail().'</a>')
 			                    	])
			                    ],[
			                        'width' => 960,
			                        'class' => []
			                    ]
			                );
						break;
/*---Restore nodes---------------------------------------------------------------------------------------------------------------*/
						case'node_restore':
							if(!empty($_POST['nid'])){
								\Drupal::database()->delete('basket_node_delete')
                                            ->condition('nid', $_POST['nid'])
                                            ->execute();
                                $response->addCommand(new InvokeCommand('body', 'append', ['<script>location.reload();</script>']));
                                \Drupal::messenger()->addMessage($this->basket->Translate()->t('Item restored but not active!'), 'warning');
							}
						break;
					}
				}
				// Hide tooltipster
				$response->addCommand(new InvokeCommand('.tooltipster-show', 'addClass', ['tooltipster-duing']));
				$response->addCommand(new InvokeCommand('.tooltipster-show', 'removeClass', ['tooltipster-show']));
				/*Alter*/
				$params = [
					'page_type'			=> $page_type,
					'page_subtype'		=> $page_subtype,
					'page_subtype1'		=> $page_subtype1
				];
				\Drupal::moduleHandler()->alter('basket_admin_page', $response, $params);
				/*END alter*/
				return $response;
			break;
		}
		/*Alter*/
		$params = [
			'page_type'			=> $page_type,
			'page_subtype'		=> $page_subtype,
			'page_subtype1'		=> $page_subtype1
		];
		\Drupal::moduleHandler()->alter('basket_admin_page', $element, $params);
		/*END alter*/
		if(!empty($element['#info']['content']['view']['CreateLink'])){
			self::$CreateLink = $element['#info']['content']['view']['CreateLink'];
			unset($element['#info']['content']['view']['CreateLink']);
		}
		$ManagerHeader = new ManagerHeader();
		$element['#info']['header'] = $ManagerHeader->block(self::$CreateLink);

		$attached = !empty($element['#attached']) ? $element['#attached'] : [];
		// ---
		$servicePopup = \Drupal::service('BasketPopup')->getInstanceByID($this->basket->getSettings('popup_plugin', 'config.admin'));
		if(!empty($servicePopup)){
			$servicePopup->attached($attached);
		}
		// ---
		$attached['library'][] = 'basket/admin';
		$element['#attached'] = $attached;
        return $element;
  	}
  	private function addBlockLine(){
  		return [
  			'#prefix'		=> '<div class="add_block_list">',
  			'#suffix'		=> '</div>',
  			[
  				$this->addGoodItems()+[
  					'#prefix'		=> '<div class="item">',
  					'#suffix'		=> '</div>'
  				]
  			],[
  				'#type'			=> 'link',
  				'#title'		=> $this->basket->Translate()->t('Add an order'),
  				'#url'			=> new Url('basket.admin.pages', [
  					'page_type'		=> 'orders-add'
  				], [
  					'ico_name'		=> 'orders.svg'
  				]),
  				'#prefix'		=> '<div class="item">',
  				'#suffix'		=> '</div>'
  			],[
  				'#type'			=> 'link',
  				'#title'		=> $this->basket->Translate()->t('Add a user'),
  				'#url'			=> new Url('basket.admin.pages', [
  					'page_type'		=> 'statistics-buyers-add'
  				], [
  					'ico_name'		=> 'visitors.svg'
  				]),
  				'#prefix'		=> '<div class="item">',
  				'#suffix'		=> '</div>',
  				'#access'		=> \Drupal::currentUser()->hasPermission('administer users')
  			],[
  				'#type'			=> 'link',
  				'#title'		=> $this->basket->Translate()->t('Trash can'),
  				'#url'			=> new Url('basket.admin.pages', [
  					'page_type'		=> 'trash'
  				], [
  					'ico_name'		=> 'trash.svg'
  				]),
  				'#prefix'		=> '<div class="item">',
  				'#suffix'		=> '</div>',
  				'#access'		=> \Drupal::currentUser()->hasPermission('basket access_trash_page')
  			]
  		];
  	}
  	private function addGoodItems(){
  		$element = [
  			'#type'			=> 'inline_template',
  			'#template'		=> '<a href="{{url}}" class="{{class|join(\' \')}}" data-position="bottom"><span class="ico">{{ico|raw}}</span>{{text}}</a><div class="tooltipster_content">{{tooltipster|raw}}</div>',
  			'#context'		=> [
  				'text'			=> $this->basket->Translate()->t('Add a product'),
  				'ico'			=> $this->basket->getIco('product.svg'),
  				'url'			=> 'javascript:void(0);',
  				'class'			=> [],
  				'tooltipster'	=> []
  			],
  			'#access'		=> FALSE
  		];
  		$NodeTypes = $this->basket->getNodeTypes();
  		if(!empty($NodeTypes)){
	  		if(count($NodeTypes) == 1){
	  			$NodeType = reset($NodeTypes);
	  			if(\Drupal::currentUser()->hasPermission('create '.$NodeType->type.' content')){
		  			$element['#context']['url'] = Url::fromRoute('basket.admin.pages', [
		  				'page_type'		=> 'stock-create-'.$NodeType->type
		  			])->toString();
	  				$element['#access'] = TRUE;
	  			}
	  		} else {
	  			$element['#context']['class'][] = 'tooltipster_init';
	  			foreach ($NodeTypes as $NodeType){
	  				if(empty($NodeType->NodeType)) continue;
	  				if(\Drupal::currentUser()->hasPermission('create '.$NodeType->type.' content')){
		  				$element['#context']['tooltipster'][] = [
		  					'#type'			=> 'link',
		  					'#title'		=> $NodeType->NodeType->label(),
		  					'#url'			=> new Url('basket.admin.pages', [
		  						'page_type'		=> 'stock-create-'.$NodeType->type
		  					]),
		  					'#suffix'		=> '<br/>'
		  				];
		  				$element['#access'] = TRUE;
	  				}
	  			}
	  		}
  		}
  		return $element;
  	}
}
