<?php

namespace Drupal\basket\Plugin\Basket\DeliverySettings;

use Drupal\basket\Plugins\DeliverySettings\Annotation\BasketDeliverySettings;
use Drupal\basket\Plugins\DeliverySettings\BasketDeliverySettingsInterface;

/**
 * @BasketDeliverySettings(
 *          id        		= "basket_address_field_settings",
 *          name      		= "DeliverySettings address",
 *			parent_field	= "basket_address_field"
 * )
 */
class DeliveryAddressFieldSettings implements BasketDeliverySettingsInterface {
	
	protected static $Basket;
	protected static $Settings;

	function __construct(){
		self::$Basket = \Drupal::service('Basket');
	}

	public function settingsFormAlter(&$form, $form_state){
		$tid = $form['tid']['#value'];

		$form['settings'] = [
			'#type'			=> 'details',
			'#title'		=> self::$Basket->Translate()->t('Settings'),
			'#open'			=> TRUE,
			'#parents'		=> ['basket_address_field_settings'],
			'#tree'			=> TRUE,
			'required'		=> [
				'#type'			=> 'checkbox',
				'#title'		=> self::$Basket->Translate()->t('Required field'),
				'#default_value'=> self::$Basket->getSettings('delivery_settings', $tid.'.required')
			],
			'title'			=> [
				'#type'			=> 'textfield',
				'#title'		=> self::$Basket->Translate()->t('Title').' EN:',
				'#default_value'=> self::$Basket->getSettings('delivery_settings', $tid.'.title')
			],
			'title_display'	=> [
				'#type'			=> 'checkbox',
				'#title'		=> self::$Basket->Translate()->t('Display title'),
				'#default_value'=> self::$Basket->getSettings('delivery_settings', $tid.'.title_display')
			],
			'placeholder'	=> [
				'#type'			=> 'textfield',
				'#title'		=> self::$Basket->Translate()->t('Placeholder').':',
				'#default_value'=> self::$Basket->getSettings('delivery_settings', $tid.'.placeholder')
			]
		];
		$form['#submit'][] = __CLASS__.'::formSubmit';
	}
	public function getSettingsInfoList($tid){
		$items = [];
		if(!empty($settings = self::$Basket->getSettings('delivery_settings', $tid))){
			$items[] = [
				'#type'			=> 'inline_template',
				'#template'		=> '<b>{{ label }}: </b> {{ value }}',
				'#context'		=> [
					'label'			=> self::$Basket->Translate()->t('Required field'),
					'value'			=> !empty($settings['required']) ? self::$Basket->Translate()->t('yes') : self::$Basket->Translate()->t('no')
				]
			];
			$items[] = [
				'#type'			=> 'inline_template',
				'#template'		=> '<b>{{ label }}: </b> {{ value }} {{ translate }}',
				'#context'		=> [
					'label'			=> self::$Basket->Translate()->t('Title'),
					'value'			=> !empty($settings['title']) ? self::$Basket->Translate()->t(trim($settings['title'])) : NULL,
					'translate'		=> !empty($settings['title']) ? self::$Basket->Translate()->getTranslateLink(trim($settings['title'])) : NULL,
				]
			];
			$items[] = [
				'#type'			=> 'inline_template',
				'#template'		=> '<b>{{ label }}: </b> {{ value }} {{ translate }}',
				'#context'		=> [
					'label'			=> self::$Basket->Translate()->t('Display title'),
					'value'			=> !empty($settings['title_display']) ? self::$Basket->Translate()->t('yes') : self::$Basket->Translate()->t('no')
				]
			];
			$items[] = [
				'#type'			=> 'inline_template',
				'#template'		=> '<b>{{ label }}: </b> {{ value }} {{ translate }}',
				'#context'		=> [
					'label'			=> self::$Basket->Translate()->t('Placeholder'),
					'value'			=> !empty($settings['placeholder']) ? self::$Basket->Translate()->t(trim($settings['placeholder'])) : NULL,
					'translate'		=> !empty($settings['placeholder']) ? self::$Basket->Translate()->getTranslateLink(trim($settings['placeholder'])) : NULL,
				]
			];
		}
		return $items;
	}
	public static function formSubmit($form, $form_state){
		$tid = $form_state->getValue('tid');
		if(!empty($tid)){
			\Drupal::service('Basket')->setSettings(
				'delivery_settings', 
	            $tid, 
	            $form_state->getValue('basket_address_field_settings')
			);
		}
	}
}