<?php

namespace Drupal\basket\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Form\FormStateInterface;

/**
 *
 * @Block(
 *   id = "basket_currency_rate",
 *   admin_label = "Basket currency rate",
 *   category = "Basket currency",
 * )
 */
class BasketCurrencyRateBlock extends BlockBase{

	protected $basket;

	public function __construct(){
		$this->basket = \Drupal::service('Basket');
	}

	public function build(){
		$currency = $this->basket->Currency()->tree();
		foreach ($currency as $key => $item){
			if(empty($this->configuration['currency_enabled'][$item->id])) unset($currency[$key]);
		}
	    return [
	    	'#theme'		=> 'basket_rate_block',
	    	'#info'			=> [
	    		'items'			=> $currency
	    	],
	    	'#cache'		=> [
	    		'tags'			=> [
	    			\Drupal::service('cache_context.basket_currency')->getCacheTag()
	    		],
	    	]
	    ];
	}
	public function blockForm($form, FormStateInterface $form_state){
		$options = [];
		foreach ($this->basket->Currency()->tree() as $key => $item){
			$options[$item->id] = $item->iso;
		}
		$form['currency'] = [
			'#type'			=> 'checkboxes',
			'#title'		=> $this->basket->Translate()->t('Currency'),
			'#options'		=> $options,
			'#default_value'=> !empty($this->configuration['currency_enabled']) ? $this->configuration['currency_enabled'] : NULL
		];
		return $form;
	}
	public function blockSubmit($form, FormStateInterface $form_state) {
		if (!$form_state->getErrors()){
			$this->configuration['currency_enabled'] = $form_state->getValue('currency');
		}
	}
}