<?php
/**
 * @ViewsField("basket_cart_all_params")
 */

namespace Drupal\basket\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

class BasketCartAllParams extends FieldPluginBase{
    public function query(){
        $params = $this->options['group_type'] != 'group' ? ['function' => $this->options['group_type']] : [];
        $this->query->addField('basket', 'nid', 'basket_row_nid', $params);
        $this->query->addField('basket', 'all_params', 'basket_row_all_params', $params);
    }
    public function render(ResultRow $values){
        if(!empty($values->basket_row_all_params) && !empty($values->basket_row_nid)){
            $params = \Drupal::service('Basket')->Cart()->decodeParams($values->basket_row_all_params);
            return \Drupal::service('BasketParams')->getDefinitionParams($params, $values->basket_row_nid);
        }
        return [];
    }
}