<?php
/**
 * @ViewsField("basket_product_counts_field")
 */

namespace Drupal\basket\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;
use Drupal\basket\Query\BasketGetNodeCountsQuery;

class BasketProductCountsField extends FieldPluginBase{
	/**
   	* Called to add the field to a query.
   	*/
	public function query() {
       // We don't need to modify query for this particular example.
        BasketGetNodeCountsQuery::viewsJoin($this);
    }
    /**
   	* {@inheritdoc}
   	*/
  	public function clickSort($order) {
        BasketGetNodeCountsQuery::viewsJoinSort($this, $order);
  	}
  	/**
   	* {@inheritdoc}
   	*/
    public function render(ResultRow $values){
        return [
            '#type'         => 'inline_template',
            '#template'     => '<div class="basket_count">
                <span class="count">{{ counts|round(2) }}</span>
                {#<span class="info-help">{{ ico|raw }}</span>
                <span class="info-help-content">test</span>#}
            </div>',
            '#context'      => [
                'counts'        => !empty($values->basket_node_counts) ? $values->basket_node_counts : 0,
                'ico'           => \Drupal::service('Basket')->getIco('help.svg')
            ]
        ];
    }
}
