<?php
/**
 * @ViewsFilter("basket_product_status_field")
 */

namespace Drupal\basket\Plugin\views\filter;

use Drupal\views\Plugin\views\filter\FilterPluginBase;
use Drupal\Core\Form\FormStateInterface;

class BasketProductStatusField extends FilterPluginBase{

    protected $basket;

    public function __construct(){
        call_user_func_array(array('parent', '__construct'), func_get_args());
        $this->basket = \Drupal::service('Basket');
    }

    public function buildExposedForm(&$form, FormStateInterface $form_state){
    	if (empty($this->options['exposed'])) {
      		return;
    	}
    	$identifier = $this->options['expose']['identifier'];
    	$form[$identifier] = [
            '#type'         => 'select',
            '#options'      => [
                1               => $this->basket->Translate()->t('Active'),
                0               => $this->basket->Translate()->t('Not active'),
            ],
            '#empty_option' => ''
        ];
    }
    public function acceptExposedInput($input){
    	if(isset($input[$this->options['expose']['identifier']]) && is_numeric($input[$this->options['expose']['identifier']])){
    		$this->value = $input[$this->options['expose']['identifier']];
    		return TRUE;
    	}
    	return FALSE;
    }
	public function query(){
		if(isset($this->value)){
			$this->query->addWhere(1,'node_field_data.status', $this->value);
		}
	}
}