<?php

namespace Drupal\basket;

use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Menu\MenuLinkTreeInterface;
use Drupal\Core\Menu\MenuTreeParameters;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;

class ToolbarHandler implements ContainerInjectionInterface {
	
	protected $menuLinkTree;
	protected $account;
	protected $BasketTranslate;

	public function __construct(MenuLinkTreeInterface $menu_link_tree, ConfigFactoryInterface $config_factory, AccountProxyInterface $account) {
		$this->menuLinkTree = $menu_link_tree;
		$this->account = $account;
		$this->BasketTranslate = \Drupal::service('Basket')->Translate();
	}
	public static function create(ContainerInterface $container) {
    return new static(
    	$container->get('toolbar.menu_tree'),
      $container->get('config.factory'),
      $container->get('current_user')
    );
  }
  public function toolbar(){
  	$items['basket'] = [
	   	'#cache' 		=> [
	     	'contexts' 		=> ['user.permissions'],
	   	],
  	];
   	if($this->account->hasPermission('basket order_access')){
   		$items['basket'] += [
   			'#type' 			=> 'toolbar_item',
   			'#weight' 			=> 999,
   			'tab'				=> [
   				'#type' 			=> 'link',
   				'#title'			=> $this->BasketTranslate->t('Shop'),
   				'#url'				=> new Url('basket.admin'),
          '#options'          => [
              'attributes'       => [
                'class'             => 'toolbar-item basket-toolbar-item'
              ]
            ]
    			]
    		];
    	}
  		return $items;
  	}
}