<?php

namespace Drupal\basket\Admin;

class BasketDeleteConfirm{
  	public static function confirmContent($params = array()){
        $BasketTranslate = \Drupal::service('Basket')->Translate();
        return [
            '#prefix'       => '<div class="form-actions">',
            '#suffix'       => '</div>',
            'submit'        => [
                '#type'         => 'inline_template',
                '#template'     => '<a href="javascript:void(0);" class="button" onclick="{{onclick}}" data-post="{{post}}">'.$BasketTranslate->t('Delete').'</a>
                                    <a href="javascript:void(0);" class="button button--danger" onclick="{{onclick_close}}"">'.$BasketTranslate->t('Cancel').'</a>',
                '#context'      => [
                    'onclick'       => !empty($params['onclick']) ? $params['onclick'] : '',
                    'post'          => !empty($params['post']) ? $params['post'] : '',
                    'onclick_close' => \Drupal::service('BasketPopup')->getCloseOnclick()
                ]
            ]
        ];
    }
}