<?php

namespace Drupal\basket\Admin\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class DiscountSystemForm extends FormBase{
	
    protected static $Basket;

	public function __construct(){
		self::$Basket = \Drupal::service('Basket');
	}
	public function getFormId(){
    	return 'basket_discount_system_settings';
  	}
  	public function buildForm(array $form, FormStateInterface $form_state){
        $form['enabled'] = [
            '#type'         => 'checkbox',
            '#title'        => self::$Basket->Translate()->t('Enable service'),
            '#default_value'=> self::$Basket->getSettings('enabled_services', 'discount_system'),
        ];
        $form['config_wrap'] = [
            '#type'         => 'container',
            '#states'       => [
                'visible'       => [
                    'input[name="enabled"]' => ['checked' => TRUE]
                ]
            ],
            'description'   => [
                '#markup'       => '<div class="description">'.self::$Basket->Translate()->t('The maximum discount from the presented systems is taken into account.').'</div>'
            ],
            'config'        => [
                '#type'         => 'table',
                '#header'       => [
                    '',
                    self::$Basket->Translate()->t('Service'),
                    self::$Basket->Translate()->t('Settings'),
                ],
                '#empty'        => self::$Basket->Translate()->t('The list is empty.')
            ]
        ];
        $BasketDiscounts = \Drupal::service('BasketDiscount')->getDefinitions();
        if(!empty($BasketDiscounts)){
            foreach ($BasketDiscounts as $BasketDiscount){
                $form['config_wrap']['config'][$BasketDiscount['id']] = [
                    'active'        => [
                        '#type'         => 'checkbox',
                        '#title'        => $BasketDiscount['id'],
                        '#attributes'   => [
                            'class'         => ['not_label']
                        ],
                        '#default_value'=> self::$Basket->getSettings('discount_system', 'config.'.$BasketDiscount['id'].'.active')
                    ],
                    'name'          => [
                        '#markup'       => self::$Basket->Translate($BasketDiscount['provider'])->t(trim($BasketDiscount['name']))
                    ],
                    'settings'      => \Drupal::service('BasketDiscount')->getInstanceByID($BasketDiscount['id'])->settingsLink()
                ];
            }
        }
        $form['actions'] = [
            '#type'         => 'actions',
            'submit'        => [
                '#type'         => 'submit',
                '#value'        => self::$Basket->Translate()->t('Save')
            ]
        ];
        return $form;
  	}
  	public function submitForm(array &$form, FormStateInterface $form_state){
        // enabled_services
        self::$Basket->setSettings(
            'enabled_services', 
            'discount_system', 
            $form_state->getValue('enabled')
        );
        self::$Basket->setSettings('discount_system', 'config', $form_state->getValue('config'));
    }
}