<?php

namespace Drupal\basket\Admin\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\InvokeCommand;
use \Drupal\Core\Url;
use Drupal\basket\Admin\Page\ExtraFieldsNodeTypeForm;

class SettingsNotificationsForm extends FormBase{
	protected static $Basket;
	public function __construct(){
		self::$Basket = \Drupal::service('Basket');
	}
	public function getFormId(){
    	return 'basket_notifications_form_settings';
  	}
  	public function buildForm(array $form, FormStateInterface $form_state, $type = '', $tid = NULL){
        $form['config'] = [
            '#tree'         => TRUE,
            '#type'         => 'table'
        ];
        // notification_order_admin
        $form['config'][] = [
            [
                '#type'         => 'checkbox',
                '#title'        => self::$Basket->Translate()->t('Admin notification of new order'),
                '#default_value'=> self::$Basket->getSettings('notifications', 'config.notification_order_admin'),
                '#parents'      => ['config', 'notification_order_admin']
            ],[
                '#type'         => 'textarea',
                '#default_value'=> self::$Basket->getSettings('notifications', 'config.notification_order_admin_mails'),
                '#parents'      => ['config', 'notification_order_admin_mails'],
                '#states'       => [
                    'visible'       => [
                        'input[name="config[notification_order_admin]"]' => ['checked' => TRUE]
                    ]
                ],
                '#attributes'   => [
                    'placeholder'   => self::$Basket->Translate()->t('One line - one email')
                ],
                '#rows'         => 2
            ],[
                'data'          => self::setTemplateLink('notification_order_admin')
            ]
        ];
        // notification_order_user
        $form['config'][] = [
            [
                '#type'         => 'checkbox',
                '#title'        => self::$Basket->Translate()->t('Notification to the user about the created order'),
                '#default_value'=> self::$Basket->getSettings('notifications', 'config.notification_order_user'),
                '#parents'      => ['config', 'notification_order_user']
            ],[
                '#type'             => 'select',
                '#options'          => self::$Basket->getNodeTypeFields('basket_order', ['email']),
                '#empty_option'    => '',
                '#default_value'=> self::$Basket->getSettings('notifications', 'config.notification_order_user_field'),
                '#parents'      => ['config', 'notification_order_user_field'],
                '#states'       => [
                    'visible'       => [
                        'input[name="config[notification_order_user]"]' => ['checked' => TRUE]
                    ]
                ],
            ],[
                'data'          => self::setTemplateLink('notification_order_user')
            ]
        ];
        // ---
        $form['actions'] = [
            '#type'         => 'actions',
            'submit'        => [
                '#type'         => 'submit',
                '#value'        => t('Save configuration')
            ]
        ];
        return $form;
  	}
  	public function submitForm(array &$form, FormStateInterface $form_state){
        self::$Basket->setSettings('notifications', 'config', $form_state->getValue('config'));
    }
    private static function setTemplateLink($type){
        return [
            '#type'         => 'container',
            '#states'       => [
                'visible'       => [
                    'input[name="config['.$type.']"]'    => ['checked' => TRUE]
                ]
            ],[
                '#type'         => 'inline_template',
                '#template'     => '<a href="{{url}}" target="_blank"><span class="ico">{{ico|raw}}</span> {{text}}</a>',
                '#context'      => [
                    'ico'           => self::$Basket->getIco('settings_row.svg'),
                    'text'          => self::$Basket->Translate()->t('Customize the template'),
                    'url'           => new Url('basket.admin.pages', ['page_type' => 'settings-templates-'.$type])
                ]
            ]
        ];
    }
}