<?php

namespace Drupal\basket\Plugin\Basket\Discount;

use Drupal\basket\Plugins\Discount\Annotation\BasketDiscount;
use Drupal\basket\Plugins\Discount\BasketDiscountInterface;
use Drupal\Core\Url;

/**
 * @BasketDiscount(
 *          id        = "discount_user_percent",
 *          name      = "Individual user discount",
 * )
 */
class DiscountUserPercent implements BasketDiscountInterface {

	protected static $Basket;
	protected static $getCurrentUserPercent;

	function __construct(){
		self::$Basket = \Drupal::service('Basket');
	}
	// Получаем ссылку на редактирование
	public function settingsLink(){
		if(self::$Basket->full('StatisticsBuyers')) {
			return [
				'#type'			=> 'link',
				'#title'		=> self::$Basket->Translate()->t('Settings page'),
				'#url'			=> new Url('basket.admin.pages', [
					'page_type'		=> 'statistics-buyers'
				], [
					'attributes'	=> [
						'class'			=> ['button--link target'],
						'target'		=> '_blank'
					]
				])
			];
		} else {
			return [
				'#type'			=> 'link',
				'#title'		=> self::$Basket->Translate()->t('Settings page'),
				'#url'			=> new Url('view.user_admin_people.page_1', [], [
					'attributes'	=> [
						'class'			=> ['button--link target'],
						'target'		=> '_blank'
					]
				])
			];
		}
	}
	// Скидка на отдельную позицию корзины
	public function discountItem($item){
		return self::$Basket->getCurrentUserPercent();
	}
}