<?php
/**
 * @ViewsField("basket_order_id")
 */

namespace Drupal\basket\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

class BasketOrderID extends FieldPluginBase{

    protected $basket;
    const NEW_COLOR = '#00A337';

    public function __construct(){
        call_user_func_array(array('parent', '__construct'), func_get_args());
        $this->basket = \Drupal::service('Basket');
    }

    public function render(ResultRow $values){
    	$id = $this->basket->Orders($this->getValue($values))->getId();
        if($this->basket->Orders($this->getValue($values))->isNew()){
            return $this->basket->textColor(
    			$id,
    			$this::NEW_COLOR
    		);
    	} else {
    		return $id;
    	}
    }
}