<?php

namespace Drupal\basket\Admin\Page;

use Drupal\Core\Url;

/**
 * {@inheritdoc}
 */
class NodeEdit {

  /**
   * Set entity.
   *
   * @var object
   */
  protected $entity;

  /**
   * Set basket.
   *
   * @var Drupal\basket\Basket
   */
  protected $basket;

  /**
   * {@inheritdoc}
   */
  public function __construct($nid) {
    $this->entity = \Drupal::entityTypeManager()->getStorage('node')->load($nid);
    $this->basket = \Drupal::service('Basket');
  }

  /**
   * {@inheritdoc}
   */
  public function editPage() {
    if (!\Drupal::currentUser()->hasPermission('edit any ' . $this->entity->bundle() . ' content')) {
      return $this->basket->getError(403);
    }
    $operations = \Drupal::entityTypeManager()->getListBuilder($this->entity->getEntityTypeId())->getOperations($this->entity);
    $allLinks = [];
    $isDelete = \Drupal::database()->select('basket_node_delete', 'n')
      ->fields('n')
      ->condition('n.nid', $this->entity->id())
      ->execute()->fetchField();
    if ($isDelete) {
      $allLinks['restore'] = [
        'onclick'     => 'basket_admin_ajax_link(this, \'' . Url::fromRoute('basket.admin.pages', ['page_type' => 'api-node_restore'])->toString() . '\')',
        'post'        => json_encode(['nid' => $this->entity->id()]),
        'title'       => $this->basket->Translate()->t('Restore'),
        'ico'         => $this->basket->getIco('restore.svg'),
      ];
      $allLinks['delete'] = [
        'url'         => new Url('entity.node.delete_form', ['node' => $this->entity->id()]),
        'title'       => $this->basket->Translate()->t('Permanently remove'),
        'ico'         => $this->basket->getIco('trash.svg'),
      ];
    }
    return [
      '#prefix'       => '<div class="basket_table_wrap">',
      '#suffix'       => '</div>',
    [
      '#prefix'       => '<div class="b_title">',
      '#suffix'       => '</div>',
      '#type'         => 'inline_template',
      '#template'     => '{{ title }}
				<a href="{{ view.url }}" target="_blank" class="button--link"><span class="ico">{{ view.ico|raw }}</span> {{ view.text }}</a>
				{% if translate %}
					<a href="{{ translate.url }}" target="_blank" class="button--link"><span class="ico">{{ ico_translate|raw }}</span> {{ translate.title }}</a>
				{% endif %}
				{% if quick_clone %}
					<a href="{{ quick_clone.url }}" target="_blank" class="button--link"><span class="ico">{{ ico_quick_clone|raw }}</span> {{ quick_clone.title }}</a>
				{% endif %}
				{% if restore %}
					<a href="javascript:void(0);" class="button--link" onclick="{{ restore.onclick }}" data-post="{{ restore.post }}"><span class="ico">{{ restore.ico|raw }}</span> {{ restore.title }}</a>
				{% endif %}
				{% if delete %}
					<a href="{{ delete.url }}" class="button--link"><span class="ico">{{ delete.ico|raw }}</span> {{ delete.title }}</a>
				{% endif %}',
      '#context'      => [
        'title'         => $this->entity->getTitle(),
        'translate'     => !empty($operations['translate']) ? $operations['translate'] : NULL,
        'ico_translate' => $this->basket->getIco('google.svg'),
        'view'          => [
          'text'          => $this->basket->Translate()->t('View'),
          'url'           => Url::fromRoute('entity.node.canonical', ['node' => $this->entity->id()])->toString(),
          'ico'           => $this->basket->getIco('eye.svg'),
        ],
        'quick_clone'   => !empty($operations['quick_clone']) ? $operations['quick_clone'] : NULL,
        'ico_quick_clone' => $this->basket->getIco('clone.svg'),
      ] + $allLinks,
    ], [
      '#prefix'       => '<div class="b_content">',
      '#suffix'       => '</div>',
      'form'          => \Drupal::service('entity.form_builder')->getForm($this->entity),
    ],
    ];
  }

}
