<?php

namespace Drupal\basket\Plugin\views\sort;

use Drupal\views\Plugin\views\sort\SortPluginBase;
use Drupal\basket\Query\BasketGetNodeCountsQuery;

/**
 * Default implementation of the base sort plugin.
 *
 * @ingroup views_sort_handlers
 *
 * @ViewsSort("basket_product_counts_field")
 */
class BasketProductCountsField extends SortPluginBase {

  /**
   * Called to add the field to a query.
   */
  public function query() {
    BasketGetNodeCountsQuery::viewsJoinSort($this, $this->options['order']);
  }

}
