<?php

namespace Drupal\basket;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Menu\MenuLinkTreeInterface;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * {@inheritdoc}
 */
class ToolbarHandler implements ContainerInjectionInterface {

  /**
   * Set menuLinkTree.
   *
   * @var object
   */
  protected $menuLinkTree;

  /**
   * Set account.
   *
   * @var object
   */
  protected $account;

  /**
   * Set trans.
   *
   * @var object
   */
  protected $trans;

  /**
   * {@inheritdoc}
   */
  public function __construct(MenuLinkTreeInterface $menu_link_tree, ConfigFactoryInterface $config_factory, AccountProxyInterface $account) {
    $this->menuLinkTree = $menu_link_tree;
    $this->account = $account;
    $this->trans = \Drupal::service('Basket')->Translate();
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
        $container->get('toolbar.menu_tree'),
      $container->get('config.factory'),
      $container->get('current_user')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function toolbar() {
    $items['basket'] = [
      '#cache'         => [
        'contexts'         => ['user.permissions'],
      ],
    ];
    if ($this->account->hasPermission('basket order_access')) {
      $items['basket'] += [
        '#type'             => 'toolbar_item',
        '#weight'             => 999,
        'tab'                => [
          '#type'             => 'link',
          '#title'            => $this->trans->t('Shop'),
          '#url'                => new Url('basket.admin.pages'),
          '#options'          => [
            'attributes'       => [
              'class'             => 'toolbar-item basket-toolbar-item',
            ],
          ],
        ],
      ];
    }
    return $items;
  }

}
