<?php

namespace Drupal\basket\Plugin\views\field;

use Drupal\views\Plugin\views\display\DisplayPluginBase;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;
use Drupal\Core\Form\FormStateInterface;
use Drupal\views\ViewExecutable;
use Drupal\views\Views;

/**
 * User's individual discount field.
 *
 * @ViewsField("basket_user_percent_field")
 */
class BasketUserPercentField extends FieldPluginBase {

  protected $basket;
  protected $basketDiscount;

  protected $configServices;

  /**
   * {@inheritdoc}
   */
  public function init(ViewExecutable $view, DisplayPluginBase $display, ?array &$options = NULL) {
    parent::init($view, $display, $options);
    $this->basketDiscount = \Drupal::getContainer()->get('BasketDiscount');
    $this->basket = \Drupal::getContainer()->get('Basket');
    $this->configServices = $this->basket->getSettings('discount_system', 'config');
  }

  /**
   * {@inheritdoc}
   */
  public function query() {}

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $discounts = [];
    $uid = $values->uid ?? 0;
    $cartItem = (object)[
      'id' => microtime(true),
      'nid' => 0,
      'quantity' => 1,
    ];
    foreach ($this->basketDiscount->getDefinitions() as $definition) {

      if(empty($this->configServices[$definition['id']]['active'])) {
        continue;
      }

      $service = $this->basketDiscount->createInstance($definition['id']);
      if(!empty($service)) {
        if(method_exists($service, 'setUid')) {
          $service->setUid($uid);
        }
        $discounts[$definition['id']] = [
          'name' => t(trim($definition['name']), [], ['context' => $definition['provider']]),
          'percent' => $service->discountItem($cartItem),
        ];
      }
    }
    $maxDiscount = !empty($discounts) ? max(array_map(fn($d) => $d['percent'], $discounts)) : 0;

    return [
      '#theme' => 'basket_user_percents',
      '#info' => [
        'discounts' => $discounts,
        'maxDiscount' => $maxDiscount,
      ]
    ];
  }

}
