<?php

namespace Drupal\basket\Admin\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class EmptyTrashSettingsForm extends FormBase{
	
    protected static $Basket;

	public function __construct(){
		self::$Basket = \Drupal::service('Basket');
	}
	public function getFormId(){
    	return 'empty_trash_settings';
  	}
  	public function buildForm(array $form, FormStateInterface $form_state){
        $form['config'] = [
            '#tree'                 => TRUE,
            'delete_nodes'          => [
                '#type'                 => 'checkbox',
                '#title'                => self::$Basket->Translate()->t('Empty items in the basket'),
                '#default_value'        => self::$Basket->getSettings('empty_trash', 'config.delete_nodes')
            ],
            'delete_anonim'         => [
                '#type'                 => 'number',
                '#title'                => self::$Basket->Translate()->t('Delete, abandoned goods anonymously, through').': ',
                '#default_value'        => self::$Basket->getSettings('empty_trash', 'config.delete_anonim'),
                '#field_suffix'         => self::$Basket->Translate()->t('days'),
                '#wrapper_attributes'   => ['class' => ['auto_width']]
            ]
        ];
        $form['actions'] = [
            '#type'         => 'actions',
            'submit'        => [
                '#type'         => 'submit',
                '#value'        => self::$Basket->Translate()->t('Save')
            ]
        ];
        return $form;
  	}
  	public function submitForm(array &$form, FormStateInterface $form_state){
        self::$Basket->setSettings('empty_trash', 'config', $form_state->getValue('config'));
    }
}