<?php

namespace Drupal\basket\Admin\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class SettingsOrderPage extends FormBase{
	protected static $Basket;
	public function __construct(){
		self::$Basket = \Drupal::service('Basket');
	}
	public function getFormId(){
    	return 'basket_order_page_settings';
  	}
  	public function buildForm(array $form, FormStateInterface $form_state, $type = '', $tid = NULL){
        $form['config'] = [
            '#tree'         => TRUE,
            'view_ajax'     => [
                '#type'         => 'checkbox',
                '#title'        => self::$Basket->Translate()->t('Display basket page in popup'),
                '#default_value'=> self::$Basket->getSettings('order_page', 'config.view_ajax'),
            ],
            'view_form'     => [
                '#type'         => 'checkbox',
                '#title'        => self::$Basket->Translate()->t('Display checkout form'),
                '#default_value'=> self::$Basket->getSettings('order_page', 'config.view_form'),
            ],
        ];
        $form['actions'] = [
            '#type'         => 'actions',
            'submit'        => [
                '#type'         => 'submit',
                '#value'        => t('Save configuration')
            ]
        ];
        return $form;
  	}
  	public function submitForm(array &$form, FormStateInterface $form_state){
        self::$Basket->setSettings('order_page', 'config', $form_state->getValue('config'));
    }
}